/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.filters.auth;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import net.codestory.http.Context;
import net.codestory.http.Cookie;
import net.codestory.http.NewCookie;
import net.codestory.http.convert.TypeConvert;
import net.codestory.http.filters.Filter;
import net.codestory.http.filters.PayloadSupplier;
import net.codestory.http.filters.auth.AuthData;
import net.codestory.http.payload.Payload;
import net.codestory.http.security.SessionIdStore;
import net.codestory.http.security.User;
import net.codestory.http.security.Users;
import org.apache.commons.lang3.RandomStringUtils;

public class JsonCookieAuthFilter
implements Filter {
    private static final int ONE_DAY = (int)TimeUnit.DAYS.toSeconds(1L);
    private static final String[] DEFAULT_EXCLUDE = new String[]{".less", ".css", ".map", ".js", ".coffee", ".ico", ".jpeg", ".jpg", ".gif", ".png", ".svg", ".eot", ".ttf", ".woff", ".js", ".coffee", "robots.txt"};
    private final String uriPrefix;
    private final Users users;
    private final SessionIdStore sessionIdStore;
    private final String[] ignoreExtensions;

    public JsonCookieAuthFilter(String uriPrefix, Users users) {
        this(uriPrefix, users, SessionIdStore.inMemory(), DEFAULT_EXCLUDE);
    }

    public JsonCookieAuthFilter(String uriPrefix, Users users, SessionIdStore sessionIdStore) {
        this(uriPrefix, users, sessionIdStore, DEFAULT_EXCLUDE);
    }

    public JsonCookieAuthFilter(String uriPrefix, Users users, SessionIdStore sessionIdStore, String ignoreExtension, String ... moreIgnoreExtensions) {
        this(uriPrefix, users, sessionIdStore, (String[])Stream.concat(Stream.of(ignoreExtension), Stream.of(moreIgnoreExtensions)).toArray(String[]::new));
    }

    private JsonCookieAuthFilter(String uriPrefix, Users users, SessionIdStore sessionIdStore, String[] ignoreExtensions) {
        this.uriPrefix = uriPrefix;
        this.users = users;
        this.sessionIdStore = sessionIdStore;
        this.ignoreExtensions = ignoreExtensions;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean matches(String uri, Context context) {
        if (uri.startsWith("/auth/")) return true;
        if (!uri.startsWith(this.uriPrefix)) return false;
        if (!Stream.of(this.ignoreExtensions).noneMatch(uri::endsWith)) return false;
        return true;
    }

    @Override
    public Payload apply(String uri, Context context, PayloadSupplier nextFilter) throws IOException {
        return uri.startsWith("/auth/") ? this.authenticationUri(uri, context, nextFilter) : this.otherUri(uri, context, nextFilter);
    }

    private Payload authenticationUri(String uri, Context context, PayloadSupplier nextFilter) throws IOException {
        String method = context.method();
        if (uri.equals("/auth/signin") && method.equals("POST")) {
            return this.signin(context);
        }
        if (uri.equals("/auth/signout") && method.equals("GET")) {
            return this.signout(context);
        }
        return nextFilter.get();
    }

    private Payload otherUri(String uri, Context context, PayloadSupplier nextFilter) throws IOException {
        String login;
        String sessionId = this.readSessionIdInCookie(context);
        if (sessionId != null && (login = this.sessionIdStore.getLogin(sessionId)) != null) {
            User user = this.users.find(login);
            context.setCurrentUser(user);
            return nextFilter.get().withHeader("Cache-Control", "must-revalidate");
        }
        return Payload.seeOther("/auth/login").withCookie(JsonCookieAuthFilter.authCookie(null));
    }

    private Payload signin(Context context) {
        String password;
        String login = context.get("login");
        User user = this.users.find(login, password = context.get("password"));
        if (user == null) {
            return Payload.seeOther("/auth/login");
        }
        return Payload.seeOther(JsonCookieAuthFilter.notFavIcon(this.readRedirectUrlInCookie(context))).withCookie(JsonCookieAuthFilter.authCookie(this.buildCookie(user, "/")));
    }

    private Payload signout(Context context) {
        String sessionId = context.cookies().value("sessionId");
        if (sessionId != null) {
            this.sessionIdStore.remove(sessionId);
        }
        return Payload.seeOther("/?signout").withCookie(JsonCookieAuthFilter.authCookie(null));
    }

    private String readSessionIdInCookie(Context context) {
        AuthData authData = context.cookies().value("auth", AuthData.class);
        return authData == null ? null : authData.sessionId;
    }

    private String readRedirectUrlInCookie(Context context) {
        AuthData authData = context.cookies().value("auth", AuthData.class);
        String redirectUrl = authData == null ? null : authData.redirectAfterLogin;
        redirectUrl = redirectUrl == null ? "/" : redirectUrl;
        return redirectUrl;
    }

    private String newSessionId(String login) {
        String sessionId = RandomStringUtils.random((int)32, (boolean)true, (boolean)true);
        this.sessionIdStore.put(sessionId, login);
        return sessionId;
    }

    private String buildCookie(User user, String redirectUrl) {
        AuthData cookie = new AuthData();
        cookie.login = user.login();
        cookie.roles = user.roles();
        cookie.sessionId = this.newSessionId(user.login());
        cookie.redirectAfterLogin = redirectUrl;
        return TypeConvert.toJson(cookie);
    }

    private static Cookie authCookie(String authData) {
        NewCookie cookie = new NewCookie("auth", authData, "/", true);
        cookie.setExpiry(ONE_DAY);
        cookie.setDomain(null);
        cookie.setSecure(false);
        return cookie;
    }

    private static String notFavIcon(String redirectUrl) {
        return redirectUrl.contains("favicon.ico") ? "/" : redirectUrl;
    }
}

