/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.compilers;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.ValueResolver;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.codestory.http.compilers.CacheEntry;
import net.codestory.http.compilers.Compiler;
import net.codestory.http.compilers.Compilers;
import net.codestory.http.misc.Env;
import net.codestory.http.misc.MemoizingSupplier;
import net.codestory.http.templating.HandlebarsCompiler;

public class CompilerFacade {
    protected final Supplier<Compilers> compilers = MemoizingSupplier.memoize(() -> new Compilers(env));
    protected final Supplier<HandlebarsCompiler> handlebars = MemoizingSupplier.memoize(() -> new HandlebarsCompiler(this.compilers.get()));

    public CompilerFacade(Env env) {
    }

    public void configureHandlebars(Consumer<Handlebars> action) {
        this.handlebars.get().configure(action);
    }

    public void addHandlebarResolver(ValueResolver resolver) {
        this.handlebars.get().addResolver(resolver);
    }

    public void registerCompiler(Supplier<Compiler> compilerFactory, String targetExtension, String firstExtension, String ... moreExtensions) {
        this.compilers.get().register(compilerFactory, targetExtension, firstExtension, moreExtensions);
    }

    public boolean canCompile(String extension) {
        return this.compilers.get().canCompile(extension);
    }

    public Set<String> extensionsThatCompileTo(String extension) {
        return this.compilers.get().extensionsThatCompileTo(extension);
    }

    public String compiledExtension(String extension) {
        return this.compilers.get().compiledExtension(extension);
    }

    public CacheEntry compile(Path path, String content) {
        return this.compilers.get().compile(path, content);
    }

    public String handlebar(String template, Map<String, ?> variables) throws IOException {
        return this.handlebars.get().compile(template, variables);
    }
}

