/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import net.codestory.http.Cookies;
import net.codestory.http.Part;
import net.codestory.http.Query;
import net.codestory.http.Request;
import net.codestory.http.Response;
import net.codestory.http.convert.TypeConvert;
import net.codestory.http.injection.IocAdapter;
import net.codestory.http.io.InputStreams;
import net.codestory.http.security.User;
import net.codestory.http.templating.Site;
import net.codestory.http.types.ContentTypes;

public class Context {
    private final Request request;
    private final Response response;
    private final IocAdapter iocAdapter;
    private final Site site;
    private User currentUser;

    public Context(Request request, Response response, IocAdapter iocAdapter, Site site) {
        this.request = request;
        this.response = response;
        this.iocAdapter = iocAdapter;
        this.site = site;
    }

    public Request request() {
        return this.request;
    }

    public Response response() {
        return this.response;
    }

    public Site site() {
        return this.site;
    }

    public CORSRequestType corsRequestType() {
        String origin = this.header("Origin");
        if (origin == null) {
            return CORSRequestType.NOT_CORS;
        }
        if (Context.isInvalidOrigin(origin)) {
            return CORSRequestType.INVALID_CORS;
        }
        switch (this.method()) {
            case "OPTIONS": {
                String accessControl = this.header("Access-Control-Request-Method");
                if (accessControl == null) {
                    return CORSRequestType.ACTUAL;
                }
                return accessControl.isEmpty() ? CORSRequestType.INVALID_CORS : CORSRequestType.PRE_FLIGHT;
            }
            case "GET": 
            case "HEAD": {
                return CORSRequestType.SIMPLE;
            }
            case "POST": {
                String contentType = this.request.contentType();
                if (contentType == null) {
                    return CORSRequestType.INVALID_CORS;
                }
                return ContentTypes.SIMPLE_HTTP_REQUEST_CONTENT_TYPE_VALUES.contains(contentType.toLowerCase().trim()) ? CORSRequestType.SIMPLE : CORSRequestType.ACTUAL;
            }
            case "PUT": 
            case "DELETE": 
            case "TRACE": 
            case "CONNECT": {
                return CORSRequestType.ACTUAL;
            }
        }
        return CORSRequestType.INVALID_CORS;
    }

    public boolean isCORS() {
        return this.corsRequestType() != CORSRequestType.NOT_CORS;
    }

    public boolean isPreflight() {
        return this.corsRequestType() == CORSRequestType.PRE_FLIGHT;
    }

    private static boolean isInvalidOrigin(String origin) {
        if (origin.isEmpty() || origin.contains("%")) {
            return true;
        }
        try {
            return new URI(origin).getScheme() == null;
        }
        catch (URISyntaxException e) {
            return true;
        }
    }

    public String uri() {
        return this.request.uri();
    }

    public Cookies cookies() {
        return this.request.cookies();
    }

    public List<Part> parts() {
        return this.request.parts();
    }

    public Query query() {
        return this.request.query();
    }

    public String get(String key) {
        return this.request.query().get(key);
    }

    public String header(String name) {
        return this.request.header(name);
    }

    public List<String> headers(String name) {
        return this.request.headers(name);
    }

    public String method() {
        return this.request.method();
    }

    public String clientAddress() {
        String forwarded = this.header("X-Forwarded-For");
        return forwarded != null ? forwarded : this.request.clientAddress().toString();
    }

    public byte[] content() {
        try {
            return InputStreams.readBytes(this.request.inputStream());
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read content", e);
        }
    }

    public String contentAsString() {
        try {
            return this.request.content();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read content", e);
        }
    }

    public <T> T contentAs(Class<T> type) {
        try {
            String json = this.request.content();
            return TypeConvert.fromJson(json, type);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable read content", e);
        }
    }

    public <T> T getBean(Class<T> type) {
        return this.iocAdapter.get(type);
    }

    public void setCurrentUser(User user) {
        this.currentUser = user;
    }

    public User currentUser() {
        return this.currentUser;
    }

    public boolean isUrlEncodedForm() {
        String contentType = this.header("Content-Type");
        return contentType != null && contentType.contains("application/x-www-form-urlencoded");
    }

    public Object extract(Type type) {
        ParameterizedType parameterizedType;
        Type rawType;
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isAssignableFrom(Context.class)) {
                return this;
            }
            if (clazz.isAssignableFrom(Request.class)) {
                return this.request();
            }
            if (clazz.isAssignableFrom(Response.class)) {
                return this.response();
            }
            if (clazz.isAssignableFrom(Cookies.class)) {
                return this.cookies();
            }
            if (clazz.isAssignableFrom(Query.class)) {
                return this.query();
            }
            if (clazz.isAssignableFrom(User.class)) {
                return this.currentUser();
            }
            if (clazz.isAssignableFrom(byte[].class)) {
                return this.content();
            }
            if (clazz.isAssignableFrom(String.class)) {
                return this.contentAsString();
            }
            if (clazz.isAssignableFrom(Site.class)) {
                return this.site();
            }
        }
        if (type instanceof ParameterizedType && (rawType = (parameterizedType = (ParameterizedType)type).getRawType()) instanceof Class) {
            if (List.class.isAssignableFrom((Class)rawType)) {
                Type argument;
                Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                if (actualTypeArguments.length == 1 && (argument = actualTypeArguments[0]) instanceof Class && Part.class.isAssignableFrom((Class)argument)) {
                    return this.parts();
                }
            } else if (Map.class.isAssignableFrom((Class)rawType)) {
                return this.query().keyValues();
            }
        }
        if (this.isUrlEncodedForm()) {
            return TypeConvert.convertValue(this.query().keyValues(), type);
        }
        try {
            String json = this.request.content();
            return TypeConvert.fromJson(json, type);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable read content", e);
        }
    }

    public static enum CORSRequestType {
        SIMPLE,
        ACTUAL,
        PRE_FLIGHT,
        NOT_CORS,
        INVALID_CORS;

    }
}

