/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.common.smartcollection;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.KeyFor;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ReflexiveMapView<T>
extends AbstractMap<T, T> {
    private final Set<@KeyFor(value={"this"}) T> domain;

    public ReflexiveMapView(Set<T> domain) {
        this.domain = Collections.unmodifiableSet(domain);
    }

    @Override
    public Set<Map.Entry<@KeyFor(value={"this"}) T, T>> entrySet() {
        return new EntrySet();
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        return this.containsKey(value);
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        return this.domain.contains(key);
    }

    @Override
    public @Nullable T get(@Nullable Object key) {
        return (T)(this.domain.contains(key) ? key : null);
    }

    @Override
    public Set<@KeyFor(value={"this"}) T> keySet() {
        return this.domain;
    }

    @Override
    public Set<T> values() {
        return this.domain;
    }

    private final class Iter
    implements Iterator<Map.Entry<T, T>> {
        final Iterator<@KeyFor(value={"this"}) T> iter;

        private Iter() {
            this.iter = ReflexiveMapView.this.domain.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Map.Entry<@KeyFor(value={"this"}) T, T> next() {
            @KeyFor(value={"this"}) T next = this.iter.next();
            return new AbstractMap.SimpleImmutableEntry(next, next);
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<T, T>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<@KeyFor(value={"this"}) T, T>> iterator() {
            return new Iter();
        }

        @Override
        public int size() {
            return ReflexiveMapView.this.domain.size();
        }
    }
}

