/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.common.smartcollection;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import net.automatalib.common.smartcollection.AbstractSmartCollection;
import net.automatalib.common.smartcollection.CapacityManagement;
import net.automatalib.common.smartcollection.ElementReference;
import net.automatalib.common.smartcollection.InvalidReferenceException;
import net.automatalib.common.smartcollection.SmartDynamicPriorityQueue;
import net.automatalib.common.util.array.ArrayStorage;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BinaryHeap<E>
extends AbstractSmartCollection<E>
implements SmartDynamicPriorityQueue<E>,
CapacityManagement,
Queue<E> {
    private static final int DEFAULT_INITIAL_CAPACITY = 10;
    private final Comparator<? super E> comparator;
    private final ArrayStorage<Reference<E>> entries;
    private int size;

    protected BinaryHeap(int initCapacity, Collection<? extends E> initValues, Comparator<? super E> comparator) {
        this(Math.max(initCapacity, initValues.size()), comparator);
        int i = 0;
        for (E e : initValues) {
            this.entries.set(i++, new Reference<E>(0, e));
        }
        this.size = initValues.size();
        for (int j = this.size / 2; j >= 0; --j) {
            super.downHeap(j);
        }
    }

    protected BinaryHeap(int initialCapacity, Comparator<? super E> comparator) {
        this.entries = new ArrayStorage(initialCapacity);
        this.comparator = comparator;
    }

    private void downHeap(@UnknownInitialization(value=BinaryHeap.class) BinaryHeap<E> this, int idx) {
        Reference e = (Reference)this.entries.get(idx);
        int iter = idx;
        while (this.hasChildren(iter)) {
            int rcidx;
            Reference rc;
            int cidx = BinaryHeap.leftChild(iter);
            Reference c = (Reference)this.entries.get(cidx);
            if (this.hasRightChild(iter) && this.compare(rc = (Reference)this.entries.get(rcidx = BinaryHeap.rightChild(iter)), c) < 0) {
                cidx = rcidx;
                c = rc;
            }
            if (this.compare(e, c) <= 0) break;
            this.entries.set(cidx, (Object)e);
            this.entries.set(iter, (Object)c);
            c.index = iter;
            iter = cidx;
        }
        e.index = iter;
    }

    private boolean hasChildren(@UnknownInitialization(value=BinaryHeap.class) BinaryHeap<E> this, int idx) {
        return idx * 2 < this.size;
    }

    private static int leftChild(int parent) {
        return 2 * parent;
    }

    private boolean hasRightChild(@UnknownInitialization(value=BinaryHeap.class) BinaryHeap<E> this, int idx) {
        return idx * 2 + 1 < this.size;
    }

    private static int rightChild(int parent) {
        return 2 * parent + 1;
    }

    private int compare(@UnknownInitialization(value=BinaryHeap.class) BinaryHeap<E> this, Reference<E> e1, Reference<E> e2) {
        return this.comparator.compare(((Reference)e1).element, ((Reference)e2).element);
    }

    public static <E extends Comparable<E>> BinaryHeap<E> create() {
        return BinaryHeap.create(10);
    }

    public static <E extends Comparable<E>> BinaryHeap<E> create(int initialCapacity) {
        return new BinaryHeap(initialCapacity, Comparator.naturalOrder());
    }

    public static <E extends Comparable<E>> BinaryHeap<E> create(Collection<? extends E> initValues) {
        return BinaryHeap.create(0, initValues);
    }

    public static <E extends Comparable<E>> BinaryHeap<E> create(int initialCapacity, Collection<? extends E> initValues) {
        return new BinaryHeap<E>(initialCapacity, initValues, Comparator.naturalOrder());
    }

    public static <E> BinaryHeap<E> createCmp(Comparator<? super E> comparator) {
        return BinaryHeap.createCmp(comparator, 10);
    }

    public static <E> BinaryHeap<E> createCmp(Comparator<? super E> comparator, int initialCapacity) {
        return new BinaryHeap<E>(initialCapacity, comparator);
    }

    public static <E> BinaryHeap<E> createCmp(Comparator<? super E> comparator, Collection<? extends E> initValues) {
        return BinaryHeap.createCmp(comparator, 0, initValues);
    }

    public static <E> BinaryHeap<E> createCmp(Comparator<? super E> comparator, int initialCapacity, Collection<? extends E> initValues) {
        return new BinaryHeap<E>(initialCapacity, initValues, comparator);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public E get(ElementReference ref) {
        return (E)((Reference)BinaryHeap.asHeapRef(ref)).element;
    }

    private static <E> Reference<E> asHeapRef(ElementReference ref) {
        if (ref.getClass() != Reference.class) {
            throw new InvalidReferenceException("Reference is of wrong class '" + ref.getClass().getName() + "', should be " + Reference.class.getName() + ".");
        }
        return (Reference)ref;
    }

    @Override
    public ElementReference referencedAdd(E elem) {
        this.ensureCapacity(this.size + 1);
        Reference<E> entry = new Reference<E>(this.size, elem);
        this.entries.set(this.size, entry);
        this.upHeap(this.size++);
        return entry;
    }

    @Override
    public void remove(ElementReference ref) {
        this.remove(((Reference)BinaryHeap.asHeapRef(ref)).index);
    }

    private void remove(int index) {
        this.forceToTop(index);
        this.extractMin();
    }

    @Override
    public E remove() {
        return this.extractMin();
    }

    private void forceToTop(int idx) {
        Reference e = (Reference)this.entries.get(idx);
        int iter = idx;
        while (BinaryHeap.hasParent(iter)) {
            int pidx = BinaryHeap.parent(iter);
            Reference p = (Reference)this.entries.set(pidx, (Object)e);
            this.entries.set(iter, (Object)p);
            p.index = iter;
            iter = BinaryHeap.parent(iter);
        }
        e.index = iter;
    }

    @Override
    public Iterator<ElementReference> referenceIterator() {
        return new ReferenceIterator();
    }

    @Override
    public void replace(ElementReference ref, E newElement) {
        Reference<E> heapRef = BinaryHeap.asHeapRef(ref);
        ((Reference)heapRef).element = newElement;
        this.keyChanged(ref);
    }

    @Override
    public void keyChanged(ElementReference ref) {
        this.keyChanged(((Reference)BinaryHeap.asHeapRef(ref)).index);
    }

    public void keyChanged(int index) {
        this.upHeap(index);
        this.downHeap(index);
    }

    @Override
    public boolean ensureCapacity(int minCapacity) {
        return this.entries.ensureCapacity(minCapacity);
    }

    private void upHeap(int idx) {
        int pidx;
        Reference p;
        Reference e = (Reference)this.entries.get(idx);
        int iter = idx;
        while (BinaryHeap.hasParent(iter) && this.compare(e, p = (Reference)this.entries.get(pidx = BinaryHeap.parent(iter))) < 0) {
            this.entries.set(pidx, (Object)e);
            this.entries.set(iter, (Object)p);
            p.index = iter;
            iter = BinaryHeap.parent(iter);
        }
        e.index = iter;
    }

    private static boolean hasParent(int idx) {
        return idx > 0;
    }

    private static int parent(int child) {
        return child / 2;
    }

    @Override
    public boolean ensureAdditionalCapacity(int additionalCapacity) {
        return this.ensureCapacity(this.size + additionalCapacity);
    }

    @Override
    public void hintNextCapacity(int nextCapacityHint) {
        this.entries.ensureCapacity(nextCapacityHint);
    }

    @Override
    public void quickClear() {
        this.size = 0;
    }

    @Override
    public void deepClear() {
        this.quickClear();
        this.entries.setAll(null);
    }

    @Override
    public boolean offer(E e) {
        this.add(e);
        return true;
    }

    @Override
    public @Nullable E poll() {
        if (this.size > 0) {
            return this.extractMin();
        }
        return null;
    }

    @Override
    public E element() {
        return this.peekMin();
    }

    @Override
    public E peekMin() {
        if (this.size <= 0) {
            throw new NoSuchElementException();
        }
        return (E)((Reference)this.entries.get(0)).element;
    }

    @Override
    public E extractMin() {
        if (this.size <= 0) {
            throw new NoSuchElementException();
        }
        Object min = ((Reference)this.entries.get(0)).element;
        this.entries.set(0, (Object)((Reference)this.entries.get(--this.size)));
        this.entries.set(this.size, null);
        if (this.size > 0) {
            this.downHeap(0);
        }
        return (E)min;
    }

    @Override
    public @Nullable E peek() {
        if (this.size > 0) {
            return this.peekMin();
        }
        return null;
    }

    private final class ReferenceIterator
    implements Iterator<ElementReference> {
        private int current;

        private ReferenceIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.current < BinaryHeap.this.size;
        }

        @Override
        public ElementReference next() {
            if (this.current >= BinaryHeap.this.size) {
                throw new NoSuchElementException();
            }
            return (ElementReference)BinaryHeap.this.entries.get(this.current++);
        }

        @Override
        public void remove() {
            BinaryHeap.this.remove(--this.current);
        }
    }

    private static final class Reference<E>
    implements ElementReference {
        private int index;
        private E element;

        Reference(int index, E element) {
            this.element = element;
            this.index = index;
        }
    }
}

