/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.common.smartcollection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.automatalib.common.smartcollection.AbstractSmartCollection;
import net.automatalib.common.smartcollection.BinaryHeap;
import net.automatalib.common.smartcollection.ElementReference;
import net.automatalib.common.smartcollection.SmartDynamicPriorityQueue;
import net.automatalib.common.smartcollection.SmartGeneralPriorityQueue;
import net.automatalib.common.util.collection.IteratorUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BackedGeneralPriorityQueue<E, K extends Comparable<K>>
extends AbstractSmartCollection<E>
implements SmartGeneralPriorityQueue<E, K> {
    private static final int DEFAULT_INITIAL_CAPACITY = 10;
    private final SmartDynamicPriorityQueue<Entry<E, K>> backingQueue;
    private @Nullable K defaultKey;

    public BackedGeneralPriorityQueue() {
        this(10);
    }

    public BackedGeneralPriorityQueue(int initialCapacity) {
        this.backingQueue = BinaryHeap.create(initialCapacity);
    }

    public BackedGeneralPriorityQueue(List<? extends E> init, List<K> keys) {
        ArrayList<Entry<E, Comparable>> entries = new ArrayList<Entry<E, Comparable>>(init.size());
        Iterator<E> elemIt = init.iterator();
        Iterator<K> keyIt = keys.iterator();
        while (elemIt.hasNext()) {
            Comparable key = keyIt.hasNext() ? (Comparable)keyIt.next() : null;
            entries.add(new Entry<E, Comparable>(elemIt.next(), key));
        }
        this.backingQueue = BinaryHeap.create(entries);
    }

    public BackedGeneralPriorityQueue(Collection<Entry<E, K>> backingQueue) {
        this(backingQueue.size());
        this.backingQueue.addAll(backingQueue);
    }

    @Override
    public E choose() {
        return ((Entry)this.backingQueue.choose()).element;
    }

    @Override
    public ElementReference chooseRef() {
        return this.backingQueue.chooseRef();
    }

    @Override
    public @Nullable ElementReference find(@Nullable Object element) {
        for (ElementReference ref : this.backingQueue.references()) {
            Entry entry = (Entry)this.backingQueue.get(ref);
            if (!Objects.equals(entry.element, element)) continue;
            return ref;
        }
        return null;
    }

    @Override
    public void quickClear() {
        this.backingQueue.quickClear();
    }

    @Override
    public void deepClear() {
        this.backingQueue.deepClear();
    }

    @Override
    public Iterator<E> iterator() {
        return IteratorUtil.map(this.backingQueue.iterator(), e -> e.element);
    }

    @Override
    public E get(ElementReference ref) {
        return ((Entry)this.backingQueue.get((ElementReference)ref)).element;
    }

    @Override
    public ElementReference referencedAdd(E elem) {
        return this.add(elem, this.defaultKey);
    }

    @Override
    public ElementReference add(E elem, @Nullable K key) {
        Entry<E, K> entry = new Entry<E, K>(elem, key);
        return this.backingQueue.referencedAdd(entry);
    }

    @Override
    public void setDefaultKey(K defaultKey) {
        this.defaultKey = defaultKey;
    }

    @Override
    public void changeKey(ElementReference ref, K newKey) {
        Entry entry = (Entry)this.backingQueue.get(ref);
        entry.key = newKey;
        this.backingQueue.keyChanged(ref);
    }

    @Override
    public void remove(ElementReference ref) {
        this.backingQueue.remove(ref);
    }

    @Override
    public Iterator<ElementReference> referenceIterator() {
        return this.backingQueue.referenceIterator();
    }

    @Override
    public void replace(ElementReference ref, E newElement) {
        Entry entry = (Entry)this.backingQueue.get(ref);
        entry.element = newElement;
    }

    @Override
    public int size() {
        return this.backingQueue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backingQueue.isEmpty();
    }

    @Override
    public void clear() {
        this.backingQueue.clear();
    }

    @Override
    public E peekMin() {
        return ((Entry)this.backingQueue.peekMin()).element;
    }

    @Override
    public E extractMin() {
        return ((Entry)this.backingQueue.extractMin()).element;
    }

    public static class Entry<E, K extends Comparable<K>>
    implements Comparable<Entry<E, K>> {
        public E element;
        public @Nullable K key;

        Entry(E element, @Nullable K key) {
            this.element = element;
            this.key = key;
        }

        @Override
        public int compareTo(Entry<E, K> o) {
            if (o.key == null) {
                return this.key == null ? 0 : -1;
            }
            return this.key == null ? 1 : this.key.compareTo(o.key);
        }
    }
}

