/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.common.smartcollection;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.automatalib.common.smartcollection.AbstractSmartCollection;
import net.automatalib.common.smartcollection.ElementReference;
import net.automatalib.common.smartcollection.LinkedListEntry;
import net.automatalib.common.smartcollection.SmartSequence;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.EnsuresQualifierIf;

public abstract class AbstractLinkedList<E, T extends LinkedListEntry<E, T>>
extends AbstractSmartCollection<E>
implements SmartSequence<E> {
    private @Nullable T head;
    private @Nullable T last;
    private int size;

    protected @Nullable T getFrontEntry() {
        return this.head;
    }

    protected @Nullable T getBackEntry() {
        return this.last;
    }

    public void concat(AbstractLinkedList<? extends E, ? extends T> other) {
        if (other.isEmpty()) {
            return;
        }
        if (this.isEmpty()) {
            this.head = other.head;
        } else {
            T otherHead = other.head;
            this.last.setNext(otherHead);
            otherHead.setPrev(this.last);
        }
        this.last = other.last;
        this.size += other.size;
        other.clear();
    }

    @Override
    public E choose() {
        if (this.head == null) {
            throw new NoSuchElementException();
        }
        return this.head.getElement();
    }

    @Override
    public ElementReference chooseRef() {
        if (this.head == null) {
            throw new NoSuchElementException();
        }
        return this.head;
    }

    @Override
    public Iterator<E> iterator() {
        return new ElementIterator(this, this.head);
    }

    @Override
    public E get(ElementReference ref) {
        return ((LinkedListEntry)ref).getElement();
    }

    @Override
    public ElementReference referencedAdd(E elem) {
        T entry = this.makeEntry(elem);
        this.pushBackEntry(entry);
        return entry;
    }

    @Override
    public void remove(ElementReference elem) {
        this.removeEntry((LinkedListEntry)elem);
    }

    protected void removeEntry(T entry) {
        Object prev = entry.getPrev();
        Object next = entry.getNext();
        if (prev != null) {
            prev.setNext(next);
        } else {
            this.head = next;
        }
        if (next != null) {
            next.setPrev(prev);
        } else {
            this.last = prev;
        }
        --this.size;
    }

    @Override
    public Iterator<ElementReference> referenceIterator() {
        return new LinkedListEntryIterator(this, this.head);
    }

    @Override
    public void replace(ElementReference ref, E newElement) {
        T newEntry = this.makeEntry(newElement);
        this.replaceEntry((LinkedListEntry)ref, newEntry);
    }

    protected void replaceEntry(T oldEntry, T newEntry) {
        T prev = oldEntry.getPrev();
        T next = newEntry.getNext();
        if (prev != null) {
            prev.setNext(newEntry);
        } else {
            this.head = newEntry;
        }
        if (next != null) {
            next.setPrev(newEntry);
        } else {
            this.last = newEntry;
        }
    }

    protected abstract T makeEntry(E var1);

    protected void pushBackEntry(T e) {
        e.setNext(null);
        e.setPrev(this.last);
        if (this.last != null) {
            this.last.setNext(e);
        } else {
            this.head = e;
        }
        this.last = e;
        ++this.size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    @EnsuresQualifierIf(qualifier=NonNull.class, expression={"this.head", "this.last"}, result=false)
    public boolean isEmpty() {
        return this.head == null || this.last == null;
    }

    @Override
    public void clear() {
        this.head = null;
        this.last = null;
        this.size = 0;
    }

    public E getBack() {
        if (this.last == null) {
            throw new NoSuchElementException();
        }
        return this.last.getElement();
    }

    public @Nullable ElementReference getBackReference() {
        return this.last;
    }

    public E getFront() {
        if (this.head == null) {
            throw new NoSuchElementException();
        }
        return this.head.getElement();
    }

    public @Nullable ElementReference getFrontReference() {
        return this.head;
    }

    public E popBack() {
        return this.popBackEntry().getElement();
    }

    protected @Nullable T popBackEntry() {
        if (this.last == null) {
            return null;
        }
        Object prev = this.last.getPrev();
        if (prev != null) {
            prev.setNext(null);
        } else {
            this.head = null;
        }
        Object e = this.last;
        this.last = prev;
        e.setPrev(null);
        --this.size;
        return (T)e;
    }

    public E popFront() {
        return this.popFrontEntry().getElement();
    }

    protected @Nullable T popFrontEntry() {
        if (this.head == null) {
            return null;
        }
        Object next = this.head.getNext();
        if (next != null) {
            next.setPrev(null);
        } else {
            this.last = null;
        }
        Object e = this.head;
        this.head = next;
        e.setNext(null);
        --this.size;
        return (T)e;
    }

    public ElementReference pushBack(E element) {
        T entry = this.makeEntry(element);
        this.pushBackEntry(entry);
        return entry;
    }

    public ElementReference pushFront(E element) {
        T entry = this.makeEntry(element);
        this.pushFrontEntry(entry);
        return entry;
    }

    protected void pushFrontEntry(T e) {
        e.setPrev(null);
        e.setNext(this.head);
        if (this.head != null) {
            this.head.setPrev(e);
        } else {
            this.last = e;
        }
        this.head = e;
        ++this.size;
    }

    @Override
    public @Nullable ElementReference pred(ElementReference ref) {
        return this.castRef(ref).getPrev();
    }

    protected T castRef(ElementReference ref) {
        return (T)((LinkedListEntry)ref);
    }

    @Override
    public @Nullable ElementReference succ(ElementReference ref) {
        return this.castRef(ref).getNext();
    }

    @Override
    public ElementReference insertBefore(E element, ElementReference ref) {
        T entry = this.makeEntry(element);
        this.insertBeforeEntry(entry, (LinkedListEntry)ref);
        return entry;
    }

    protected void insertBeforeEntry(T e, T insertPos) {
        T oldPrev = insertPos.getPrev();
        e.setNext(insertPos);
        e.setPrev(oldPrev);
        insertPos.setPrev(e);
        if (oldPrev != null) {
            oldPrev.setNext(e);
        } else {
            this.head = e;
        }
        ++this.size;
    }

    @Override
    public ElementReference insertAfter(E element, ElementReference ref) {
        T entry = this.makeEntry(element);
        this.insertAfterEntry(entry, (LinkedListEntry)ref);
        return entry;
    }

    protected void insertAfterEntry(T e, T insertPos) {
        T oldNext = insertPos.getNext();
        e.setNext(oldNext);
        e.setPrev(insertPos);
        insertPos.setNext(e);
        if (oldNext != null) {
            oldNext.setPrev(e);
        } else {
            this.last = e;
        }
        ++this.size;
    }

    public void swap(AbstractLinkedList<E, T> other) {
        int sizeTmp = this.size;
        T headTmp = this.head;
        T lastTmp = this.last;
        this.size = other.size;
        this.head = other.head;
        this.last = other.last;
        other.size = sizeTmp;
        other.head = headTmp;
        other.last = lastTmp;
    }

    private static class ElementIterator
    implements Iterator<E> {
        private @Nullable T prev;
        private @Nullable T current;
        final /* synthetic */ AbstractLinkedList this$0;

        ElementIterator(T head) {
            this.this$0 = var1_1;
            this.current = head;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public E next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            Object e = this.current;
            this.current = this.current.getNext();
            this.prev = e;
            return e.getElement();
        }

        @Override
        public void remove() {
            if (this.prev == null) {
                throw new IllegalStateException();
            }
            this.this$0.removeEntry(this.prev);
            this.prev = null;
        }
    }

    private static class LinkedListEntryIterator
    implements Iterator<T> {
        private @Nullable T prev;
        private @Nullable T current;
        final /* synthetic */ AbstractLinkedList this$0;

        LinkedListEntryIterator(T head) {
            this.this$0 = var1_1;
            this.current = head;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public T next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            Object e = this.current;
            this.current = this.current.getNext();
            this.prev = e;
            return e;
        }

        @Override
        public void remove() {
            if (this.prev == null) {
                throw new IllegalStateException();
            }
            this.this$0.removeEntry(this.prev);
            this.prev = null;
        }
    }
}

