/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.database.mybatis.plus.config;

import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import javax.sql.DataSource;
import ltd.fdsa.core.util.NamingUtils;
import ltd.fdsa.database.mybatis.plus.annotation.MybatisPlusMapper;
import ltd.fdsa.database.mybatis.plus.interceptor.AutoUpdateHandler;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

@Configuration
@MapperScan(basePackages={"**.mybatis.plus.mapper.writer.**"}, annotationClass=MybatisPlusMapper.class, sqlSessionFactoryRef="PLUS_WRITE_SQL_SESSION_FACTORY")
public class WriterConfig {
    private static final Logger log = LoggerFactory.getLogger(WriterConfig.class);
    public static final String WRITE_SQL_SESSION_FACTORY = "PLUS_WRITE_SQL_SESSION_FACTORY";
    @Value(value="${mybatis.mapperLocations:classpath:mybatisMappers/**/*.xml}")
    String mapperLocation;
    @Value(value="${mybatis.config-location:classpath:mybatis-config.xml}")
    String configLocation;
    @Value(value="${project.mybatis.data.security:false}")
    boolean security;

    @Bean(name={"PLUS_WRITE_SQL_SESSION_FACTORY"})
    public SqlSessionFactory writeSqlSessionFactory(@Qualifier(value="dataSource") DataSource dataSource) throws Exception {
        NamingUtils.formatLog((Logger)log, (String)"WriteSqlSessionFactory Start For PLUS", (Object[])new Object[0]);
        MybatisSqlSessionFactoryBean sessionFactoryBean = new MybatisSqlSessionFactoryBean();
        PathMatchingResourcePatternResolver pr = new PathMatchingResourcePatternResolver();
        sessionFactoryBean.setDataSource(dataSource);
        sessionFactoryBean.setConfigLocation(pr.getResource(this.configLocation));
        sessionFactoryBean.setMapperLocations(pr.getResources(this.mapperLocation));
        GlobalConfig globalConfig = new GlobalConfig();
        globalConfig.setMetaObjectHandler((MetaObjectHandler)new AutoUpdateHandler());
        globalConfig.setBanner(false);
        sessionFactoryBean.setGlobalConfig(globalConfig);
        SqlSessionFactory sessionFactory = sessionFactoryBean.getObject();
        if (this.security) {
            org.apache.ibatis.session.Configuration configuration = sessionFactory.getConfiguration();
        }
        return sessionFactory;
    }
}

