/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.database.jpa.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import ltd.fdsa.database.entity.BaseEntity;
import ltd.fdsa.database.entity.Status;
import ltd.fdsa.database.jpa.repository.reader.ReadRepository;
import ltd.fdsa.database.jpa.repository.writer.WriteRepository;
import ltd.fdsa.database.service.DataAccessService;
import ltd.fdsa.database.sql.conditions.Condition;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

public class BaseJpaService<Entity extends BaseEntity<ID>, ID, Writer extends WriteRepository<Entity, ID>, Reader extends ReadRepository<Entity, ID>>
implements DataAccessService<Entity, ID> {
    @Autowired
    protected WriteRepository<Entity, ID> writer;
    @Autowired
    protected ReadRepository<Entity, ID> reader;

    public Optional<Entity> findById(ID id) {
        return this.reader.findById(id);
    }

    public List<Entity> findAll() {
        return this.reader.findAll();
    }

    public long count() {
        return this.reader.count();
    }

    public List<Entity> findAllById(ID ... ids) {
        return null;
    }

    public Page<Entity> findAll(Pageable pageable) {
        return this.reader.findAll(pageable);
    }

    public boolean existsById(ID id) {
        return false;
    }

    public List<Entity> find(Condition where) {
        return Collections.emptyList();
    }

    public Entity update(Entity entity) {
        Optional result = this.writer.findById(entity.getId());
        if (result.isPresent()) {
            BaseEntity target = (BaseEntity)result.get();
            BeanUtils.copyProperties(entity, (Object)target, (String[])new String[]{"createTime", "createBy"});
            return (Entity)((BaseEntity)this.writer.save(target));
        }
        return null;
    }

    public void deleteAll(Entity ... entities) {
        for (Entity entity : entities) {
            entity.setStatus(Status.DELETE);
        }
        this.writer.saveAll(Lists.newArrayList((Object[])entities));
    }

    public void updateAll(Entity ... entities) {
        this.writer.saveAll(Lists.newArrayList((Object[])entities));
    }

    public void deleteById(ID id) {
        Optional result = this.writer.findById(id);
        if (result.isPresent() && ((BaseEntity)result.get()).getStatus() != Status.DELETE) {
            BaseEntity entity = (BaseEntity)result.get();
            entity.setStatus(Status.DELETE);
            this.writer.saveAndFlush(entity);
        }
    }

    public void clearAll() {
        this.writer.deleteAllInBatch();
    }

    public Entity insert(Entity entity) {
        return (Entity)((BaseEntity)this.writer.save(entity));
    }

    public void insertAll(Entity ... entities) {
        ArrayList list = Lists.newArrayList((Object[])entities);
        this.writer.saveAll(list);
    }
}

