/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.database.jpa.config;

import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import ltd.fdsa.database.datasource.DataSourceProperties;
import ltd.fdsa.database.jpa.registrar.UserIdAuditorAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.jdbc.repository.config.AbstractJdbcConfiguration;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.data.relational.core.dialect.AnsiDialect;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@EnableJpaRepositories(basePackages={"**.jpa.repository.writer.**"}, entityManagerFactoryRef="writerEntityManagerFactory", transactionManagerRef="writerTransactionManager")
@EnableJpaAuditing
public class WriterConfig
extends AbstractJdbcConfiguration {
    private static final Logger log = LoggerFactory.getLogger(WriterConfig.class);
    public static final String WRITER_ENTITY_MANAGER_FACTORY = "writerEntityManagerFactory";
    public static final String WRITER_TRANSACTION_MANAGER = "writerTransactionManager";
    @Value(value="${project.jpa.entity.packages:**.jpa.entity.**}")
    private String[] entityPackages;

    public Dialect jdbcDialect(NamedParameterJdbcOperations operations) {
        return AnsiDialect.INSTANCE;
    }

    @Bean(name={"writerEntityManagerFactory"})
    @Primary
    public LocalContainerEntityManagerFactoryBean writerEntityManagerFactory(@Qualifier(value="dataSource") DataSource dataSource, DataSourceProperties properties) {
        LocalContainerEntityManagerFactoryBean entityManagerFactoryBean = new LocalContainerEntityManagerFactoryBean();
        HibernateJpaVendorAdapter adapter = new HibernateJpaVendorAdapter();
        adapter.setShowSql(properties.isShowSql());
        adapter.setGenerateDdl(properties.isGenerateDdl());
        adapter.setDatabasePlatform(properties.getDialect());
        entityManagerFactoryBean.setDataSource(dataSource);
        entityManagerFactoryBean.setJpaVendorAdapter((JpaVendorAdapter)adapter);
        entityManagerFactoryBean.setPackagesToScan(this.entityPackages);
        return entityManagerFactoryBean;
    }

    @Bean(name={"writerTransactionManager"})
    public PlatformTransactionManager writerTransactionManager(@Qualifier(value="writerEntityManagerFactory") EntityManagerFactory entityManagerFactory) {
        JpaTransactionManager transactionManager = new JpaTransactionManager();
        transactionManager.setEntityManagerFactory(entityManagerFactory);
        return transactionManager;
    }

    @Bean
    @Primary
    public UserIdAuditorAware userIdAuditorAware() {
        return new UserIdAuditorAware();
    }
}

