/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.database.jpa.config;

import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import ltd.fdsa.database.datasource.DataSourceProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@EnableJpaRepositories(basePackages={"**.jpa.repository.reader.**"}, entityManagerFactoryRef="readerEntityManagerFactory", transactionManagerRef="readerTransactionManager")
public class ReaderConfig {
    private static final Logger log = LoggerFactory.getLogger(ReaderConfig.class);
    public static final String READER_ENTITY_MANAGER_FACTORY = "readerEntityManagerFactory";
    public static final String READER_TRANSACTION_MANAGER = "readerTransactionManager";
    @Value(value="${project.jpa.entity.packages:**.jpa.entity.**}")
    private String[] entityPackages;

    @Bean(name={"readerEntityManagerFactory"})
    public LocalContainerEntityManagerFactoryBean readerEntityManagerFactory(@Qualifier(value="readerDataSource") DataSource dataSource, DataSourceProperties properties) {
        LocalContainerEntityManagerFactoryBean entityManagerFactoryBean = new LocalContainerEntityManagerFactoryBean();
        HibernateJpaVendorAdapter adapter = new HibernateJpaVendorAdapter();
        adapter.setShowSql(properties.isShowSql());
        adapter.setDatabasePlatform(properties.getDialect());
        entityManagerFactoryBean.setDataSource(dataSource);
        entityManagerFactoryBean.setJpaVendorAdapter((JpaVendorAdapter)adapter);
        entityManagerFactoryBean.setPackagesToScan(this.entityPackages);
        return entityManagerFactoryBean;
    }

    @Bean(name={"readerTransactionManager"})
    public PlatformTransactionManager readerTransactionManager(@Qualifier(value="readerEntityManagerFactory") EntityManagerFactory entityManagerFactory) {
        JpaTransactionManager transactionManager = new JpaTransactionManager();
        transactionManager.setEntityManagerFactory(entityManagerFactory);
        return transactionManager;
    }
}

