/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.quack;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;

public class WeakExactHashMap<K, V> {
    private HashMap<Entry<K>, V> map = new HashMap();
    private int purgeThreshold = 0;

    public void setPurgeThreshold(int purgeThreshold) {
        this.purgeThreshold = purgeThreshold;
    }

    private void maybePurge() {
        if (this.map.size() < this.purgeThreshold) {
            return;
        }
        this.purge();
    }

    public void purge() {
        Iterator<Entry<K>> iter = this.map.keySet().iterator();
        while (iter.hasNext()) {
            Entry<K> entry = iter.next();
            if (entry.key.get() != null) continue;
            iter.remove();
        }
        int after = this.map.size();
        this.setPurgeThreshold(after * 2);
    }

    public V get(K key) {
        this.maybePurge();
        return this.map.get(new Entry<K>(key));
    }

    public V put(K key, V value) {
        this.maybePurge();
        return this.map.put(new Entry<K>(key), value);
    }

    public int size() {
        return this.map.size();
    }

    public void clear() {
        this.map.clear();
    }

    private static class Entry<K> {
        WeakReference<K> key;
        int hash;

        public Entry(K key) {
            if (key == null) {
                throw new IllegalArgumentException("key can not be null");
            }
            this.key = new WeakReference<K>(key);
            this.hash = key.hashCode();
        }

        public boolean equals(Object obj) {
            Entry other = (Entry)obj;
            Object key = this.key.get();
            return key != null && other.key.get() == key;
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

