/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.quack;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class QuackException
extends RuntimeException {
    private static final long serialVersionUID = 1538523787401076917L;
    private static final Pattern STACK_TRACE_PATTERN = Pattern.compile("\\s*at (\\[?)(.*?)]? \\((.*?):?(\\d+)?\\).*$");
    private static final String STACK_TRACE_CLASS_NAME = "JavaScript";

    public QuackException(String detailMessage) {
        super(QuackException.getErrorMessage(detailMessage));
        QuackException.addJSStack(this, detailMessage);
    }

    static void addJSStack(Throwable throwable, String detailMessage) {
        String[] lines = detailMessage.split("\n", -1);
        if (lines.length <= 1) {
            return;
        }
        ArrayList<StackTraceElement> elements = new ArrayList<StackTraceElement>();
        StackTraceElement[] selfTrace = new Exception().getStackTrace();
        StackTraceElement search0 = selfTrace[0];
        StackTraceElement search1 = selfTrace[1];
        StackTraceElement search2 = selfTrace[2];
        boolean spliced = false;
        for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
            if (!spliced && (stackTraceElement.equals(search0) || stackTraceElement.equals(search1) || stackTraceElement.equals(search2))) {
                spliced = true;
                for (int i = 1; i < lines.length; ++i) {
                    StackTraceElement jsElement = QuackException.toStackTraceElement(lines[i]);
                    if (jsElement == null) continue;
                    elements.add(jsElement);
                }
            }
            elements.add(stackTraceElement);
        }
        throwable.setStackTrace(elements.toArray(new StackTraceElement[elements.size()]));
    }

    static String addJavaStack(String detailMessage, Throwable throwable) {
        String[] parts = detailMessage.split("\n", 2);
        detailMessage = parts[1];
        StringBuilder ret = new StringBuilder(parts[0]);
        StackTraceElement[] selfTrace = new Exception().getStackTrace();
        StackTraceElement search0 = selfTrace[0];
        StackTraceElement search1 = selfTrace[1];
        StackTraceElement search2 = selfTrace[2];
        boolean spliced = false;
        for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
            if (!spliced && (stackTraceElement.equals(search0) || stackTraceElement.equals(search1) || stackTraceElement.equals(search2))) {
                spliced = true;
                ret.append(detailMessage);
            }
            ret.append(String.format("\n    at [%s.%s] (%s:%s)", stackTraceElement.getClassName(), stackTraceElement.getMethodName(), stackTraceElement.getFileName(), stackTraceElement.getLineNumber()));
        }
        return ret.toString();
    }

    private static String getErrorMessage(String detailMessage) {
        int end = detailMessage.indexOf(10);
        return end > 0 ? detailMessage.substring(0, end) : detailMessage;
    }

    private static StackTraceElement toStackTraceElement(String s) {
        Matcher m = STACK_TRACE_PATTERN.matcher(s);
        if (!m.matches()) {
            return null;
        }
        int line = m.group(4) != null ? Integer.parseInt(m.group(4)) : 1;
        String className = m.group(1) == null ? STACK_TRACE_CLASS_NAME : "<javascript>";
        return new StackTraceElement(className, m.group(2), m.group(3), line);
    }
}

