/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.quack;

import com.koushikdutta.quack.JavaMethodObject;
import com.koushikdutta.quack.JavaScriptObject;
import com.koushikdutta.quack.Memoize;
import com.koushikdutta.quack.QuackCoercion;
import com.koushikdutta.quack.QuackInvocationHandlerWrapper;
import com.koushikdutta.quack.QuackJavaObject;
import com.koushikdutta.quack.QuackJavaScriptObject;
import com.koushikdutta.quack.QuackMethodCoercion;
import com.koushikdutta.quack.QuackObject;
import com.koushikdutta.quack.WeakExactHashMap;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.logging.Logger;

public final class QuackContext
implements Closeable {
    private final WeakExactHashMap<Object, Object> nativeMappings = new WeakExactHashMap();
    private final Map<Class, QuackCoercion> JavaScriptToJavaCoercions = new LinkedHashMap<Class, QuackCoercion>();
    private final Map<Class, QuackCoercion> JavaToJavascriptCoercions = new LinkedHashMap<Class, QuackCoercion>();
    final Map<Method, QuackMethodCoercion> JavaScriptToJavaMethodCoercions = new LinkedHashMap<Method, QuackMethodCoercion>();
    final Map<Method, QuackMethodCoercion> JavaToJavascriptMethodCoercions = new LinkedHashMap<Method, QuackMethodCoercion>();
    private QuackInvocationHandlerWrapper invocationHandlerWrapper;
    private static boolean loaded = false;
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
    private static final Path tmpdir = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]).toAbsolutePath();
    private static final boolean WINDOWS = OS_NAME.startsWith("windows");
    private static final boolean MAC = OS_NAME.contains("mac");
    private static final String version = "1.1.0";
    static Memoize<Field> javaObjectFields;
    static Memoize<Boolean> javaObjectMethods;
    static Memoize<Method> javaObjectGetter;
    static Memoize<Method> javaObjectSetter;
    static Memoize<Method> javaObjectMethodCandidates;
    static Memoize<Constructor> javaObjectConstructorCandidates;
    static Memoize<Method> interfaceMethods;
    private boolean useQuickJS;
    private long context;
    private long totalElapsedScriptExecutionMs;
    final ArrayList<Long> finalizationQueue = new ArrayList();
    private Executor jobExecutor;
    private Object[] empty = new Object[0];

    public static synchronized boolean loadJni() {
        if (loaded) {
            return true;
        }
        ClassLoader cl = QuackContext.class.getClassLoader();
        String name = WINDOWS ? "quickjs.dll" : (MAC ? "libquickjs.dylib" : "libquickjs.so");
        Path libFile = tmpdir.resolve("quickjs-1.1.0").resolve(name);
        if (!Files.exists(libFile, new LinkOption[0])) {
            try (InputStream is = cl.getResourceAsStream("META-INF/" + name);){
                if (is == null) {
                    throw new RuntimeException("resource not found: META-INF/" + name);
                }
                if (!Files.exists(libFile.getParent(), new LinkOption[0])) {
                    Files.createDirectory(libFile.getParent(), new FileAttribute[0]);
                }
                if (!Files.exists(libFile, new LinkOption[0])) {
                    Files.createFile(libFile, new FileAttribute[0]);
                }
                Files.copy(is, libFile, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        System.load(libFile.toString());
        loaded = true;
        return true;
    }

    static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    static boolean isNumberClass(Class<?> c) {
        return c == Byte.TYPE || c == Byte.class || c == Short.TYPE || c == Short.class || c == Integer.TYPE || c == Integer.class || c == Long.TYPE || c == Long.class || c == Float.TYPE || c == Float.class || c == Double.TYPE || c == Double.class;
    }

    public void setInvocationHandlerWrapper(QuackInvocationHandlerWrapper invocationHandlerWrapper) {
        this.invocationHandlerWrapper = invocationHandlerWrapper;
    }

    private static InvocationHandler wrapObjectInvocationHandler(JavaScriptObject jo, InvocationHandler handler) {
        return (proxy, method, args) -> {
            if (method.getDeclaringClass() == Object.class) {
                return method.invoke((Object)jo, args);
            }
            return handler.invoke(proxy, method, args);
        };
    }

    InvocationHandler getWrappedInvocationHandler(JavaScriptObject javaScriptObject, InvocationHandler handler) {
        handler = QuackContext.wrapObjectInvocationHandler(javaScriptObject, handler);
        if (this.invocationHandlerWrapper == null) {
            return handler;
        }
        InvocationHandler wrapped = this.invocationHandlerWrapper.wrapInvocationHandler(javaScriptObject, handler);
        if (wrapped != null) {
            return wrapped;
        }
        return handler;
    }

    public synchronized <T> void putJavaScriptToJavaCoercion(Class<T> clazz, QuackCoercion<T, Object> coercion) {
        this.JavaScriptToJavaCoercions.put(clazz, coercion);
    }

    public synchronized <F> void putJavaToJavaScriptCoercion(Class<F> clazz, QuackCoercion<Object, F> coercion) {
        this.JavaToJavascriptCoercions.put(clazz, coercion);
    }

    public Object coerceJavaToJavaScript(Object o) {
        if (o == null) {
            return null;
        }
        return this.coerceJavaToJavaScript(o.getClass(), o);
    }

    public Object[] coerceJavaArgsToJavaScript(Object ... args) {
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                args[i] = this.coerceJavaToJavaScript(args[i]);
            }
        }
        return args;
    }

    public Object coerceJavaToJavaScript(final Class clazz, Object o) {
        Object coerced;
        if (o == null) {
            return null;
        }
        while (o instanceof QuackJavaObject && o != (coerced = ((QuackJavaObject)o).getObject())) {
            o = coerced;
        }
        Object ret = QuackContext.coerceJavaToJavaScript(this.JavaToJavascriptCoercions, o, clazz);
        if (ret != null) {
            return ret;
        }
        Method method = QuackContext.getLambdaMethod(clazz);
        if (method != null) {
            Object thiz = o;
            return new JavaMethodObject(this, thiz, method.getName()){

                @Override
                public Object callMethod(Object thiz, Object ... args) {
                    return super.callMethod(thiz, args);
                }

                @Override
                protected Method[] getMethods(Object thiz) {
                    return clazz.getMethods();
                }
            };
        }
        return o;
    }

    private static Method getLambdaMethod(Class clazz) {
        if (!clazz.isInterface()) {
            return null;
        }
        Method match = null;
        for (Method method : clazz.getMethods()) {
            if (Modifier.isStatic(method.getModifiers())) continue;
            if (match != null) {
                return null;
            }
            match = method;
        }
        return match;
    }

    public Object coerceJavaScriptToJava(Class<?> clazz, Object o) {
        Object coerced;
        if (o == null) {
            return null;
        }
        while (o instanceof QuackJavaObject && o != (coerced = ((QuackJavaObject)o).getObject())) {
            o = coerced;
        }
        if (clazz == null) {
            return o;
        }
        if (clazz.isInstance(o)) {
            return o;
        }
        if (clazz == Boolean.TYPE && o instanceof Boolean) {
            return o;
        }
        if (clazz == Byte.TYPE && o instanceof Byte) {
            return o;
        }
        if (clazz == Short.TYPE && o instanceof Short) {
            return o;
        }
        if (clazz == Integer.TYPE && o instanceof Integer) {
            return o;
        }
        if (clazz == Long.TYPE && o instanceof Long) {
            return o;
        }
        if (clazz == Float.TYPE && o instanceof Float) {
            return o;
        }
        if (clazz == Double.TYPE && o instanceof Double) {
            return o;
        }
        if ((clazz == Byte.TYPE || clazz == Byte.class) && o instanceof Double) {
            return ((Double)o).byteValue();
        }
        if ((clazz == Short.TYPE || clazz == Short.class) && o instanceof Double) {
            return ((Double)o).shortValue();
        }
        if ((clazz == Integer.TYPE || clazz == Integer.class) && o instanceof Double) {
            return ((Double)o).intValue();
        }
        if ((clazz == Float.TYPE || clazz == Float.class) && o instanceof Double) {
            return Float.valueOf(((Double)o).floatValue());
        }
        if ((clazz == Long.TYPE || clazz == Long.class) && o instanceof Double) {
            return ((Double)o).longValue();
        }
        if (clazz.isArray() && o instanceof JavaScriptObject) {
            JavaScriptObject jo = (JavaScriptObject)o;
            int length = ((Number)jo.get("length")).intValue();
            Class<?> componentType = clazz.getComponentType();
            Object ret = Array.newInstance(componentType, length);
            for (int i = 0; i < length; ++i) {
                Array.set(ret, i, this.coerceJavaScriptToJava(componentType, jo.get(i)));
            }
            return ret;
        }
        Object ret = QuackContext.coerceJavaScriptToJava(this.JavaScriptToJavaCoercions, o, clazz);
        if (ret != null) {
            return ret;
        }
        if (clazz.isInterface() && o instanceof JavaScriptObject) {
            JavaScriptObject jo = (JavaScriptObject)o;
            Method lambda = QuackContext.getLambdaMethod(clazz);
            if (lambda != null) {
                return Proxy.newProxyInstance(QuackJavaScriptObject.class.getClassLoader(), new Class[]{QuackJavaScriptObject.class, clazz}, jo.getWrappedInvocationHandler((proxy, method, args) -> this.coerceJavaScriptToJava(method.getReturnType(), jo.call(JavaScriptObject.coerceArgs(this, method, args)))));
            }
            InvocationHandler handler = jo.createInvocationHandler();
            return Proxy.newProxyInstance(QuackJavaScriptObject.class.getClassLoader(), new Class[]{QuackJavaScriptObject.class, clazz}, handler);
        }
        return o;
    }

    public static <T> Method getInterfaceMethod(Class<T> clazz, JavaMethodReference<T> ref) {
        return QuackContext.invokeMethodReferenceProxy(clazz, ref);
    }

    public static <T, A> Method getInterfaceMethod(Class<T> clazz, JavaMethodReference0<T, A> ref) {
        return QuackContext.invokeMethodReferenceProxy(clazz, ref);
    }

    public static <T, A, B> Method getInterfaceMethod(Class<T> clazz, JavaMethodReference1<T, A, B> ref) {
        return QuackContext.invokeMethodReferenceProxy(clazz, ref);
    }

    public static <T, A, B, C> Method getInterfaceMethod(Class<T> clazz, JavaMethodReference2<T, A, B, C> ref) {
        return QuackContext.invokeMethodReferenceProxy(clazz, ref);
    }

    public static <T, A, B, C, D> Method getInterfaceMethod(Class<T> clazz, JavaMethodReference3<T, A, B, C, D> ref) {
        return QuackContext.invokeMethodReferenceProxy(clazz, ref);
    }

    public static <T, A, B, C, D, E> Method getInterfaceMethod(Class<T> clazz, JavaMethodReference4<T, A, B, C, D, E> ref) {
        return QuackContext.invokeMethodReferenceProxy(clazz, ref);
    }

    static Method getInterfaceMethod(Method method) {
        return interfaceMethods.memoize(() -> {
            if (method.getDeclaringClass().isInterface()) {
                return method;
            }
            Class<?> c = method.getDeclaringClass();
            for (Class<?> iface : c.getInterfaces()) {
                for (Method m : iface.getDeclaredMethods()) {
                    if (m.getParameterTypes().length != method.getParameterTypes().length || !m.getName().equals(method.getName()) || !m.getReturnType().isAssignableFrom(method.getReturnType())) continue;
                    boolean paramMatch = true;
                    for (int i = 0; i < method.getParameterTypes().length; ++i) {
                        if (m.getParameterTypes()[i].isAssignableFrom(method.getParameterTypes()[i])) continue;
                        paramMatch = false;
                        break;
                    }
                    if (!paramMatch) continue;
                    return m;
                }
            }
            return null;
        }, method);
    }

    public synchronized void putJavaScriptToJavaMethodCoercion(Method method, QuackMethodCoercion coercion) {
        this.JavaScriptToJavaMethodCoercions.put(method, coercion);
        interfaceMethods.clear();
    }

    public synchronized void putJavaToJavaScriptMethodCoercion(Method method, QuackMethodCoercion coercion) {
        this.JavaToJavascriptMethodCoercions.put(method, coercion);
        interfaceMethods.clear();
    }

    private static Object throwInvokedMethod(Object proxy, Method method, Object[] args) throws MethodException {
        throw new MethodException(method);
    }

    private static <T> T createMethodInterceptProxy(Class<T> clazz) {
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, QuackContext::throwInvokedMethod);
    }

    private static <T> Method invokeMethodReferenceProxy(Class<T> clazz, Object ref) {
        try {
            if (ref.getClass().getDeclaredMethods().length != 1) {
                throw new Exception("expecting lambda with 1 method: getInterfaceMethod(Foo.class, Foo::bar)");
            }
            Method method = ref.getClass().getDeclaredMethods()[0];
            Object[] args = new Object[method.getParameterTypes().length];
            args[0] = QuackContext.createMethodInterceptProxy(clazz);
            method.invoke(ref, args);
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                InvocationTargetException invocationTargetException = (InvocationTargetException)e;
                if (invocationTargetException.getTargetException() instanceof UndeclaredThrowableException) {
                    UndeclaredThrowableException undeclaredThrowableException = (UndeclaredThrowableException)invocationTargetException.getTargetException();
                    if (undeclaredThrowableException.getUndeclaredThrowable() instanceof MethodException) {
                        return ((MethodException)undeclaredThrowableException.getUndeclaredThrowable()).method;
                    }
                } else if (invocationTargetException.getTargetException() instanceof NullPointerException) {
                    throw new IllegalArgumentException("lambdas with primitive arguments must be invoked with default values: getInterfaceMethod(Foo.class, thiz -> thiz.setInt(0))");
                }
            }
            throw new IllegalArgumentException(e);
        }
        throw new IllegalArgumentException("interface method was not called by lambda.");
    }

    private static Object coerceJavaToJavaScript(Map<Class, QuackCoercion> coerce, Object o, Class<?> clazz) {
        QuackCoercion coercion = coerce.get(clazz);
        if (coercion != null) {
            return coercion.coerce(clazz, o);
        }
        for (Map.Entry<Class, QuackCoercion> check : coerce.entrySet()) {
            if (!check.getKey().isAssignableFrom(clazz)) continue;
            return check.getValue().coerce(clazz, o);
        }
        return null;
    }

    private static Object coerceJavaScriptToJava(Map<Class, QuackCoercion> coerce, Object o, Class<?> clazz) {
        QuackCoercion coercion = coerce.get(clazz);
        if (coercion != null) {
            return coercion.coerce(clazz, o);
        }
        for (Map.Entry<Class, QuackCoercion> check : coerce.entrySet()) {
            if (clazz.isAssignableFrom(check.getKey())) {
                throw new AssertionError((Object)"Superclass converter not implemented.");
            }
        }
        for (Map.Entry<Class, QuackCoercion> check : coerce.entrySet()) {
            if (!check.getKey().isAssignableFrom(clazz)) continue;
            return check.getValue().coerce(clazz, o);
        }
        return null;
    }

    public static QuackContext create(boolean useQuickJS) {
        QuackContext quack = new QuackContext(useQuickJS);
        long context = QuackContext.createContext(quack, useQuickJS);
        if (context == 0L) {
            throw new OutOfMemoryError("Cannot create QuickJS instance");
        }
        quack.context = context;
        quack.useQuickJS = useQuickJS;
        return quack;
    }

    public static QuackContext create() {
        return QuackContext.create(true);
    }

    private QuackContext(boolean useQuickJS) {
        this.JavaScriptToJavaCoercions.put(Enum.class, (clazz, o) -> {
            if (o == null) {
                return null;
            }
            return Enum.valueOf(clazz, o.toString());
        });
        this.putJavaScriptToJavaCoercion(Byte.class, (clazz, o) -> o instanceof Number ? ((Number)o).byteValue() : (o instanceof String ? Byte.parseByte(o.toString()) : (Byte)o));
        this.JavaScriptToJavaCoercions.put(Byte.TYPE, (clazz, o) -> o instanceof Number ? Byte.valueOf(((Number)o).byteValue()) : (o instanceof String ? Byte.valueOf(Byte.parseByte(o.toString())) : o));
        this.putJavaToJavaScriptCoercion(Byte.TYPE, (clazz, o) -> o.intValue());
        this.putJavaToJavaScriptCoercion(Byte.class, (clazz, o) -> o.intValue());
        this.JavaScriptToJavaCoercions.put(Short.class, (clazz, o) -> o instanceof Number ? Short.valueOf(((Number)o).shortValue()) : (o instanceof String ? Short.valueOf(Short.parseShort(o.toString())) : o));
        this.JavaScriptToJavaCoercions.put(Short.TYPE, (clazz, o) -> o instanceof Number ? Short.valueOf(((Number)o).shortValue()) : (o instanceof String ? Short.valueOf(Short.parseShort(o.toString())) : o));
        this.putJavaToJavaScriptCoercion(Short.TYPE, (clazz, o) -> o.intValue());
        this.putJavaToJavaScriptCoercion(Short.class, (clazz, o) -> o.intValue());
        this.JavaScriptToJavaCoercions.put(Integer.class, (clazz, o) -> o instanceof Number ? Integer.valueOf(((Number)o).intValue()) : (o instanceof String ? Integer.valueOf(Integer.parseInt(o.toString())) : o));
        this.JavaScriptToJavaCoercions.put(Integer.TYPE, (clazz, o) -> o instanceof Number ? Integer.valueOf(((Number)o).intValue()) : (o instanceof String ? Integer.valueOf(Integer.parseInt(o.toString())) : o));
        this.JavaScriptToJavaCoercions.put(Long.class, (clazz, o) -> o instanceof Number ? Long.valueOf(((Number)o).longValue()) : (o instanceof String ? Long.valueOf(Long.parseLong(o.toString())) : o));
        this.JavaScriptToJavaCoercions.put(Long.TYPE, (clazz, o) -> o instanceof Number ? Long.valueOf(((Number)o).longValue()) : (o instanceof String ? Long.valueOf(Long.parseLong(o.toString())) : o));
        if (!useQuickJS) {
            this.putJavaToJavaScriptCoercion(Long.TYPE, (clazz, o) -> o.toString());
            this.putJavaToJavaScriptCoercion(Long.class, (clazz, o) -> o.toString());
        }
        this.JavaScriptToJavaCoercions.put(Float.class, (clazz, o) -> o instanceof Number ? Float.valueOf(((Number)o).floatValue()) : (o instanceof String ? Float.valueOf(Float.parseFloat(o.toString())) : o));
        this.JavaScriptToJavaCoercions.put(Float.TYPE, (clazz, o) -> o instanceof Number ? Float.valueOf(((Number)o).floatValue()) : (o instanceof String ? Float.valueOf(Float.parseFloat(o.toString())) : o));
        this.putJavaToJavaScriptCoercion(Float.TYPE, (clazz, o) -> o.doubleValue());
        this.putJavaToJavaScriptCoercion(Float.class, (clazz, o) -> o.doubleValue());
        this.JavaScriptToJavaCoercions.put(Double.class, (clazz, o) -> o instanceof Number ? Double.valueOf(((Number)o).doubleValue()) : (o instanceof String ? Double.valueOf(Double.parseDouble(o.toString())) : o));
        this.JavaScriptToJavaCoercions.put(Double.TYPE, (clazz, o) -> o instanceof Number ? Double.valueOf(((Number)o).doubleValue()) : (o instanceof String ? Double.valueOf(Double.parseDouble(o.toString())) : o));
        this.putJavaToJavaScriptCoercion(Enum.class, (clazz, o) -> o.toString());
        this.putJavaToJavaScriptCoercion(ByteBuffer.class, (clazz, o) -> {
            if (o.isDirect() && useQuickJS) {
                return o;
            }
            ByteBuffer direct = ByteBuffer.allocateDirect(o.remaining());
            direct.put((ByteBuffer)o);
            direct.flip();
            return direct;
        });
    }

    public long getTotalScriptExecutionTime() {
        return this.totalElapsedScriptExecutionMs;
    }

    public void resetTotalScriptExecutionTime() {
        this.totalElapsedScriptExecutionMs = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized <T> T evaluate(Class<T> clazz, String script, String fileName) {
        if (this.context == 0L) {
            return null;
        }
        long start = System.nanoTime() / 1000000L;
        try {
            Object object = this.coerceJavaScriptToJava(clazz, QuackContext.evaluate(this.context, script, fileName));
            return (T)object;
        }
        finally {
            this.totalElapsedScriptExecutionMs += System.nanoTime() / 1000000L - start;
            this.handlePostInvocation();
        }
    }

    public synchronized Object evaluate(String script, String fileName) {
        return this.evaluate(null, script, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized JavaScriptObject evaluateModule(String script, String fileName) {
        if (this.context == 0L) {
            return null;
        }
        long start = System.nanoTime() / 1000000L;
        try {
            JavaScriptObject javaScriptObject = (JavaScriptObject)this.coerceJavaScriptToJava(JavaScriptObject.class, QuackContext.evaluateModule(this.context, script, fileName));
            return javaScriptObject;
        }
        finally {
            this.totalElapsedScriptExecutionMs += System.nanoTime() / 1000000L - start;
            this.handlePostInvocation();
        }
    }

    public synchronized JavaScriptObject evaluateModule(String script) {
        return this.evaluateModule(script, "?");
    }

    public synchronized Object evaluate(String script) {
        return this.evaluate(script, "?");
    }

    public synchronized <T> T evaluate(String script, Class<T> clazz) {
        return (T)this.coerceJavaScriptToJava(clazz, this.evaluate(script));
    }

    public synchronized JavaScriptObject evaluateForJavaScriptObject(String script) {
        return this.evaluate(script, JavaScriptObject.class);
    }

    public synchronized JavaScriptObject compileFunction(String script, String fileName) {
        return QuackContext.compileFunction(this.context, script, fileName);
    }

    @Override
    public synchronized void close() {
        if (this.context != 0L) {
            long contextToClose = this.context;
            this.context = 0L;
            QuackContext.destroyContext(contextToClose);
        }
        this.nativeMappings.clear();
    }

    protected synchronized void finalize() throws Throwable {
        if (this.context != 0L) {
            Logger.getLogger(this.getClass().getName()).warning("QuickJS instance leaked!");
        }
        this.close();
    }

    public synchronized JavaScriptObject getGlobalObject() {
        return QuackContext.getGlobalObject(this.context);
    }

    public synchronized void cooperateDebugger() {
        if (this.context == 0L) {
            return;
        }
        QuackContext.cooperateDebugger(this.context);
    }

    public void waitForDebugger(String connectionString) {
        if (this.context == 0L) {
            return;
        }
        QuackContext.waitForDebugger(this.context, connectionString);
    }

    public boolean isDebugging() {
        if (this.context == 0L) {
            return false;
        }
        return QuackContext.isDebugging(this.context);
    }

    public synchronized void debuggerAppNotify(Object ... args) {
        if (this.context == 0L) {
            return;
        }
        QuackContext.debuggerAppNotify(this.context, args);
    }

    synchronized Object getKeyObject(long object, Object key) {
        if (this.context == 0L) {
            return null;
        }
        return QuackContext.getKeyObject(this.context, object, key);
    }

    synchronized Object getKeyString(long object, String key) {
        if (this.context == 0L) {
            return null;
        }
        return QuackContext.getKeyString(this.context, object, key);
    }

    synchronized Object getKeyInteger(long object, int index) {
        if (this.context == 0L) {
            return null;
        }
        return QuackContext.getKeyInteger(this.context, object, index);
    }

    synchronized boolean setKeyObject(long object, Object key, Object value) {
        if (this.context == 0L) {
            return false;
        }
        return QuackContext.setKeyObject(this.context, object, key, value);
    }

    synchronized boolean setKeyString(long object, String key, Object value) {
        if (this.context == 0L) {
            return false;
        }
        return QuackContext.setKeyString(this.context, object, key, value);
    }

    synchronized boolean setKeyInteger(long object, int index, Object value) {
        if (this.context == 0L) {
            return false;
        }
        return QuackContext.setKeyInteger(this.context, object, index, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Object call(long object, Object ... args) {
        if (this.context == 0L) {
            return null;
        }
        long start = System.nanoTime() / 1000000L;
        try {
            Object object2 = QuackContext.call(this.context, object, args);
            return object2;
        }
        finally {
            this.totalElapsedScriptExecutionMs += System.nanoTime() / 1000000L - start;
            this.handlePostInvocation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Object callConstructor(long object, Object ... args) {
        if (this.context == 0L) {
            return null;
        }
        long start = System.nanoTime() / 1000000L;
        try {
            Object object2 = QuackContext.callConstructor(this.context, object, args);
            return object2;
        }
        finally {
            this.totalElapsedScriptExecutionMs += System.nanoTime() / 1000000L - start;
            this.handlePostInvocation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Object callMethod(long object, Object thiz, Object ... args) {
        if (this.context == 0L) {
            return null;
        }
        long start = System.nanoTime() / 1000000L;
        try {
            Object object2 = QuackContext.callMethod(this.context, object, thiz, args);
            return object2;
        }
        finally {
            this.totalElapsedScriptExecutionMs += System.nanoTime() / 1000000L - start;
            this.handlePostInvocation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Object callProperty(long object, Object property, Object ... args) {
        if (this.context == 0L) {
            return null;
        }
        long start = System.nanoTime() / 1000000L;
        try {
            Object object2 = QuackContext.callProperty(this.context, object, property, args);
            return object2;
        }
        finally {
            this.totalElapsedScriptExecutionMs += System.nanoTime() / 1000000L - start;
            this.handlePostInvocation();
        }
    }

    synchronized String stringify(long object) {
        if (this.context == 0L) {
            return null;
        }
        return QuackContext.stringify(this.context, object);
    }

    public synchronized long getHeapSize() {
        if (this.context == 0L) {
            return 0L;
        }
        return QuackContext.getHeapSize(this.context);
    }

    public synchronized JavaScriptObject newError(Throwable t) {
        if (this.context == 0L) {
            return null;
        }
        try {
            Thrower thrower = () -> {
                throw t;
            };
            Catcher catcher = this.evaluate("(function(t) { try { t(); } catch (e) { return e } })", Catcher.class);
            return catcher.doCatch(thrower);
        }
        catch (Throwable unexpected) {
            return null;
        }
    }

    public synchronized void throwObject(Object o) {
        if (this.context == 0L) {
            return;
        }
        this.evaluateForJavaScriptObject("(function(t) { throw t; })").call(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finalizeJavaScriptObject(long object) {
        if (this.context == 0L) {
            return;
        }
        ArrayList<Long> arrayList = this.finalizationQueue;
        synchronized (arrayList) {
            this.finalizationQueue.add(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void finalizeJavaScriptObjects() {
        long[] copy;
        ArrayList<Long> arrayList = this.finalizationQueue;
        synchronized (arrayList) {
            if (this.finalizationQueue.isEmpty()) {
                return;
            }
            copy = new long[this.finalizationQueue.size()];
            for (int i = 0; i < this.finalizationQueue.size(); ++i) {
                copy[i] = this.finalizationQueue.get(i);
            }
            this.finalizationQueue.clear();
        }
        if (this.context == 0L) {
            return;
        }
        QuackContext.finalizeJavaScriptObjects(this.context, copy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean hasPostInvocationTasks() {
        ArrayList<Long> arrayList = this.finalizationQueue;
        synchronized (arrayList) {
            if (!this.finalizationQueue.isEmpty()) {
                return true;
            }
        }
        return QuackContext.hasPendingJobs(this.context);
    }

    private synchronized void handlePostInvocation() {
        if (!this.hasPostInvocationTasks()) {
            return;
        }
        if (this.jobExecutor == null) {
            this.runPostInvocation();
            return;
        }
        this.jobExecutor.execute(this::runPostInvocation);
    }

    synchronized void runPostInvocation() {
        if (this.context == 0L) {
            return;
        }
        this.finalizeJavaScriptObjects();
        QuackContext.runJobs(this.context);
    }

    public synchronized void setJobExecutor(Executor executor) {
        this.jobExecutor = executor;
    }

    private Object quackGet(QuackObject quackObject, Object key) {
        return quackObject.get(key);
    }

    private boolean quackHas(QuackObject quackObject, Object key) {
        return quackObject.has(key);
    }

    private boolean quackSet(QuackObject quackObject, Object key, Object value) {
        return quackObject.set(key, value);
    }

    private Object quackApply(QuackObject quackObject, Object thiz, Object ... args) {
        return quackObject.callMethod(thiz, args == null ? this.empty : args);
    }

    private Object quackConstruct(QuackObject quackObject, Object ... args) {
        return quackObject.construct(args == null ? this.empty : args);
    }

    public void quackMapNative(Object key, Object value) {
        this.nativeMappings.put(key, value);
    }

    public Object quackUnmapNative(Object key) {
        return this.nativeMappings.get(key);
    }

    private long getNativePointer(QuackJavaScriptObject quackJavaScriptObject) {
        if (quackJavaScriptObject.getNativeContext() != this.context) {
            return 0L;
        }
        return quackJavaScriptObject.getNativePointer();
    }

    private static native long getHeapSize(long var0);

    private static native long createContext(QuackContext var0, boolean var1);

    private static native void destroyContext(long var0);

    private static native Object evaluate(long var0, String var2, String var3);

    private static native Object evaluateModule(long var0, String var2, String var3);

    private static native JavaScriptObject compileFunction(long var0, String var2, String var3);

    private static native void cooperateDebugger(long var0);

    private static native void waitForDebugger(long var0, String var2);

    private static native boolean isDebugging(long var0);

    private static native void debuggerAppNotify(long var0, Object ... var2);

    private static native Object getKeyObject(long var0, long var2, Object var4);

    private static native Object getKeyString(long var0, long var2, String var4);

    private static native Object getKeyInteger(long var0, long var2, int var4);

    private static native boolean setKeyObject(long var0, long var2, Object var4, Object var5);

    private static native boolean setKeyString(long var0, long var2, String var4, Object var5);

    private static native boolean setKeyInteger(long var0, long var2, int var4, Object var5);

    private static native Object call(long var0, long var2, Object ... var4);

    private static native Object callConstructor(long var0, long var2, Object ... var4);

    private static native Object callMethod(long var0, long var2, Object var4, Object ... var5);

    private static native Object callProperty(long var0, long var2, Object var4, Object ... var5);

    private static native JavaScriptObject getGlobalObject(long var0);

    private static native String stringify(long var0, long var2);

    private static native void finalizeJavaScriptObjects(long var0, long[] var2);

    private static native boolean hasPendingJobs(long var0);

    private static native void runJobs(long var0);

    static {
        QuackContext.loadJni();
        javaObjectFields = new Memoize();
        javaObjectMethods = new Memoize();
        javaObjectGetter = new Memoize();
        javaObjectSetter = new Memoize();
        javaObjectMethodCandidates = new Memoize();
        javaObjectConstructorCandidates = new Memoize();
        interfaceMethods = new Memoize();
    }

    private static class MethodException
    extends Exception {
        private static final long serialVersionUID = -1432377890337490927L;
        Method method;

        MethodException(Method method) {
            this.method = method;
        }
    }

    private static interface Thrower {
        public void doThrow() throws Throwable;
    }

    private static interface Catcher {
        public JavaScriptObject doCatch(Thrower var1);
    }

    public static interface JavaMethodReference4<T, A, B, C, D, E> {
        public void invoke(T var1, A var2, B var3, C var4, D var5, E var6) throws Exception;
    }

    public static interface JavaMethodReference3<T, A, B, C, D> {
        public void invoke(T var1, A var2, B var3, C var4, D var5) throws Exception;
    }

    public static interface JavaMethodReference2<T, A, B, C> {
        public void invoke(T var1, A var2, B var3, C var4) throws Exception;
    }

    public static interface JavaMethodReference1<T, A, B> {
        public void invoke(T var1, A var2, B var3) throws Exception;
    }

    public static interface JavaMethodReference0<T, A> {
        public void invoke(T var1, A var2) throws Exception;
    }

    public static interface JavaMethodReference<T> {
        public void invoke(T var1) throws Exception;
    }
}

