/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.quack;

import com.koushikdutta.quack.MemoizeFunc;
import java.util.HashMap;

public class Memoize<T> {
    MemoizeMap<T> store;

    public Memoize(MemoizeMap<T> map) {
        this.store = map;
    }

    public Memoize() {
        this(new MemoizeMapImpl());
    }

    public static int hashCode(Object ... objects) {
        int ret = 0;
        for (int i = 0; i < objects.length; ++i) {
            Object o = objects[i];
            ret ^= Integer.rotateLeft(o == null ? 0 : o.hashCode(), i);
        }
        return ret ^= objects.length;
    }

    public T memoize(MemoizeFunc<T> func, Object ... args) {
        int hash = Memoize.hashCode(args);
        return this.memoize(func, hash);
    }

    void clear() {
        this.store.clear();
    }

    public T memoize(MemoizeFunc<T> func, Object arg0, Object[] args) {
        int hash = Memoize.hashCode(args);
        return this.memoize(func, hash ^= arg0 == null ? 0 : arg0.hashCode());
    }

    public T memoize(MemoizeFunc<T> func, Object arg0, Object[] args0, Object[] args1) {
        int hash = Memoize.hashCode(args0);
        hash ^= Memoize.hashCode(args1);
        return this.memoize(func, hash ^= arg0 == null ? 0 : arg0.hashCode());
    }

    private T memoize(MemoizeFunc<T> func, int hash) {
        if (this.store.containsKey(hash)) {
            return this.store.get(hash);
        }
        T ret = func.process();
        this.store.put(hash, ret);
        return ret;
    }

    public static interface MemoizeMap<V> {
        public boolean containsKey(Object var1);

        public V get(Object var1);

        public V put(Integer var1, V var2);

        public void clear();
    }

    private static class MemoizeMapImpl<V>
    extends HashMap<Integer, V>
    implements MemoizeMap<V> {
        private static final long serialVersionUID = -4020434697394716201L;

        private MemoizeMapImpl() {
        }
    }
}

