/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.quack;

import com.koushikdutta.quack.JSValue;
import com.koushikdutta.quack.QuackContext;
import com.koushikdutta.quack.QuackJavaScriptObject;
import com.koushikdutta.quack.QuackMethodCoercion;
import com.koushikdutta.quack.QuackMethodName;
import com.koushikdutta.quack.QuackObject;
import com.koushikdutta.quack.QuackProperty;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

public class JavaScriptObject
implements QuackObject,
QuackJavaScriptObject {
    public final QuackContext quackContext;
    public final long context;
    public final long pointer;

    public JavaScriptObject(QuackContext quackContext, long context, long pointer) {
        this.quackContext = quackContext;
        this.context = context;
        this.pointer = pointer;
    }

    @Override
    public long getNativePointer() {
        return this.pointer;
    }

    @Override
    public long getNativeContext() {
        return this.context;
    }

    @Override
    public JavaScriptObject getJavaScriptObject() {
        return this;
    }

    @Override
    public JavaScriptObject construct(Object ... args) {
        return this.constructCoerced(JavaScriptObject.class, args);
    }

    public <T> T constructCoerced(Class<T> clazz, Object ... args) {
        this.quackContext.coerceJavaArgsToJavaScript(args);
        return (T)this.quackContext.coerceJavaScriptToJava(clazz, this.quackContext.callConstructor(this.pointer, args));
    }

    public String typeof() {
        return (String)this.quackContext.evaluateForJavaScriptObject("(function(f) { return typeof f; })").call(this);
    }

    public String stringify() {
        return this.quackContext.stringify(this.pointer);
    }

    public Object get(String key) {
        return this.quackContext.coerceJavaScriptToJava(null, this.quackContext.getKeyString(this.pointer, key));
    }

    public Object get(int index) {
        return this.quackContext.coerceJavaScriptToJava(null, this.quackContext.getKeyInteger(this.pointer, index));
    }

    public Object call(Object ... args) {
        this.quackContext.coerceJavaArgsToJavaScript(args);
        return this.quackContext.coerceJavaScriptToJava(null, this.quackContext.call(this.pointer, args));
    }

    @Override
    public Object callMethod(Object thiz, Object ... args) {
        this.quackContext.coerceJavaArgsToJavaScript(args);
        return this.quackContext.coerceJavaScriptToJava(null, this.quackContext.callMethod(this.pointer, this.quackContext.coerceJavaToJavaScript(thiz), args));
    }

    public Object callProperty(Object property, Object ... args) {
        this.quackContext.coerceJavaArgsToJavaScript(args);
        return this.quackContext.coerceJavaScriptToJava(null, this.quackContext.callProperty(this.pointer, property, args));
    }

    @Override
    public Object get(Object key) {
        Number number;
        if (key instanceof String) {
            return this.get((String)key);
        }
        if (key instanceof Number && Integer.valueOf((number = (Number)key).intValue()).equals(number)) {
            return this.get(number.intValue());
        }
        return this.quackContext.coerceJavaScriptToJava(null, this.quackContext.getKeyObject(this.pointer, this.quackContext.coerceJavaToJavaScript(key)));
    }

    public boolean set(String key, Object value) {
        return this.quackContext.setKeyString(this.pointer, key, value);
    }

    public boolean set(int index, Object value) {
        return this.quackContext.setKeyInteger(this.pointer, index, value);
    }

    @Override
    public boolean set(Object key, Object value) {
        Number number;
        if (key instanceof String) {
            return this.set((String)key, value);
        }
        if (key instanceof Number && (number = (Number)key).doubleValue() == (double)number.intValue()) {
            return this.set(number.intValue(), value);
        }
        return this.quackContext.setKeyObject(this.pointer, key, value);
    }

    public String toString() {
        Object ret = this.callProperty("toString", new Object[0]);
        if (ret == null) {
            return null;
        }
        return ret.toString();
    }

    static Object[] coerceArgs(QuackContext quackContext, Method method, Object[] args) {
        if (args != null && args.length > 0) {
            Class<?>[] types = method.getParameterTypes();
            if (args.length != types.length) {
                throw new AssertionError((Object)"JavaScript.createInvocationHandler different args count?");
            }
            int numParameters = types.length;
            if (method.isVarArgs()) {
                --numParameters;
            }
            for (int i = 0; i < numParameters; ++i) {
                args[i] = quackContext.coerceJavaToJavaScript(types[i], args[i]);
            }
            if (method.isVarArgs()) {
                Class<?> varargType = method.getParameterTypes()[numParameters].getComponentType();
                ArrayList<Object> varargs = new ArrayList<Object>(Arrays.asList(args).subList(0, numParameters));
                Object varargArg = args[numParameters];
                for (int i = 0; i < Array.getLength(varargArg); ++i) {
                    Object vararg = Array.get(varargArg, i);
                    varargs.add(quackContext.coerceJavaScriptToJava(varargType, vararg));
                }
                args = varargs.toArray();
            }
        }
        return args;
    }

    public InvocationHandler getWrappedInvocationHandler(InvocationHandler wrapped) {
        return this.quackContext.getWrappedInvocationHandler(this, (proxy, method, args) -> {
            if (method.getDeclaringClass() == QuackJavaScriptObject.class) {
                return method.invoke((Object)this, args);
            }
            return wrapped.invoke(proxy, method, args);
        });
    }

    public InvocationHandler createInvocationHandler() {
        InvocationHandler handler = (proxy, method, args) -> {
            Method interfaceMethod = QuackContext.getInterfaceMethod(method);
            QuackMethodCoercion methodCoercion = this.quackContext.JavaToJavascriptMethodCoercions.get(interfaceMethod);
            if (methodCoercion != null) {
                return methodCoercion.invoke(interfaceMethod, this, args);
            }
            QuackProperty property = method.getAnnotation(QuackProperty.class);
            if (property != null) {
                if (args == null || args.length == 0) {
                    return this.quackContext.coerceJavaScriptToJava(method.getReturnType(), this.get(property.name()));
                }
                this.set(property.name(), this.quackContext.coerceJavaScriptToJava(method.getParameterTypes()[0], args[0]));
                return null;
            }
            String methodName = method.getName();
            QuackMethodName annotation = method.getAnnotation(QuackMethodName.class);
            if (annotation != null) {
                methodName = annotation.name();
            }
            return this.quackContext.coerceJavaScriptToJava(method.getReturnType(), this.callProperty(methodName, JavaScriptObject.coerceArgs(this.quackContext, method, args)));
        };
        return this.getWrappedInvocationHandler(handler);
    }

    public <T> T proxyInterface(Class<T> clazz, Class ... more) {
        ArrayList<Class> classes = new ArrayList<Class>();
        classes.add(QuackJavaScriptObject.class);
        classes.add(clazz);
        if (more != null) {
            Collections.addAll(classes, more);
        }
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), classes.toArray(new Class[0]), this.createInvocationHandler());
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.quackContext.finalizeJavaScriptObject(this.pointer);
    }

    public JSValue asJSValue() {
        return new JSValue(this.quackContext, this);
    }
}

