/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.quack;

import com.koushikdutta.quack.JavaMethodObject;
import com.koushikdutta.quack.QuackContext;
import com.koushikdutta.quack.QuackJavaObject;
import com.koushikdutta.quack.QuackMethodName;
import com.koushikdutta.quack.QuackObject;
import com.koushikdutta.quack.QuackProperty;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class JavaObject
implements QuackObject,
QuackJavaObject {
    private final Object target;
    private final QuackContext quackContext;

    public JavaObject(QuackContext quackContext, Object target) {
        this.quackContext = quackContext;
        this.target = target;
    }

    @Override
    public Object getObject() {
        return this.target;
    }

    public static Method getGetterMethod(String key, Method[] methods) {
        return QuackContext.javaObjectGetter.memoize(() -> {
            for (Method method : methods) {
                QuackProperty property;
                if (method.getParameterTypes().length != 0 || method.getReturnType() == Void.TYPE || method.getReturnType() == Void.class || (property = method.getAnnotation(QuackProperty.class)) == null) continue;
                String propName = property.name();
                if (QuackContext.isEmpty(propName)) {
                    propName = method.getName();
                }
                if (!propName.equals(key)) continue;
                return method;
            }
            return null;
        }, (Object)key, (Object[])methods);
    }

    public static Method getSetterMethod(String key, Method[] methods) {
        return QuackContext.javaObjectSetter.memoize(() -> {
            for (Method method : methods) {
                QuackProperty property;
                if (method.getParameterTypes().length != 1 || method.getReturnType() != Void.TYPE && method.getReturnType() != Void.class || (property = method.getAnnotation(QuackProperty.class)) == null) continue;
                String propName = property.name();
                if (QuackContext.isEmpty(propName)) {
                    propName = method.getName();
                }
                if (!propName.equals(key)) continue;
                return method;
            }
            return null;
        }, (Object)key, (Object[])methods);
    }

    private static boolean hasMethod(Class clazz, String key, boolean requiresStatic) {
        for (Method method : clazz.getMethods()) {
            if (requiresStatic && !Modifier.isStatic(method.getModifiers())) continue;
            if (method.getName().equals(key)) {
                return true;
            }
            QuackMethodName annotation = method.getAnnotation(QuackMethodName.class);
            if (annotation == null || !annotation.name().equals(key)) continue;
            return true;
        }
        return false;
    }

    private Field findField(String key, Class clazz) {
        return QuackContext.javaObjectFields.memoize(() -> {
            for (Field field : clazz.getDeclaredFields()) {
                if (!field.getName().equals(key) || (field.getModifiers() & 8) != 0 || (field.getModifiers() & 1) == 0) continue;
                return field;
            }
            if (this.target instanceof Class) {
                for (Field field : ((Class)this.target).getDeclaredFields()) {
                    if (!field.getName().equals(key) || (field.getModifiers() & 8) == 0 || (field.getModifiers() & 1) == 0) continue;
                    return field;
                }
            }
            return null;
        }, (Object)key, (Object[])clazz.getDeclaredFields());
    }

    public Object get(String key) {
        Method g;
        Object ret = this.getMap(key);
        if (ret != null) {
            return ret;
        }
        Class<?> clazz = this.target.getClass();
        if (!Proxy.isProxyClass(clazz)) {
            if (clazz.isArray() && "length".equals(key)) {
                return Array.getLength(this.target);
            }
            Field f = this.findField(key, clazz);
            if (f != null) {
                try {
                    return this.quackContext.coerceJavaToJavaScript(f.get(this.target));
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
        if ((g = JavaObject.getGetterMethod(key, clazz.getMethods())) != null) {
            try {
                return this.quackContext.coerceJavaToJavaScript(g.invoke(this.target, new Object[0]));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        Boolean m = QuackContext.javaObjectMethods.memoize(() -> {
            if (JavaObject.hasMethod(clazz, key, false)) {
                return true;
            }
            if (this.target instanceof Class) {
                return JavaObject.hasMethod((Class)this.target, key, true);
            }
            return false;
        }, (Object)key, (Object[])clazz.getMethods());
        if (m.booleanValue()) {
            return new JavaMethodObject(this.quackContext, this.target, key);
        }
        return null;
    }

    public Object get(int index) {
        if (this.target.getClass().isArray()) {
            return Array.get(this.target, index);
        }
        if (this.target instanceof List) {
            return ((List)this.target).get(index);
        }
        return null;
    }

    private Object getMap(Object key) {
        if (this.target instanceof Map) {
            return this.quackContext.coerceJavaToJavaScript(((Map)this.target).get(key));
        }
        return null;
    }

    @Override
    public Object get(Object key) {
        Number number;
        if (key instanceof String) {
            return this.get((String)key);
        }
        if (key instanceof Number && (number = (Number)key).doubleValue() == (double)number.intValue()) {
            return this.get(number.intValue());
        }
        return this.getMap(key);
    }

    private void noSet() {
        throw new UnsupportedOperationException("can not set value on this JavaObject");
    }

    public boolean set(int index, Object value) {
        if (this.target instanceof Array) {
            Array.set(this.target, index, value);
            return true;
        }
        if (this.target instanceof List) {
            ((List)this.target).set(index, value);
            return true;
        }
        this.noSet();
        return false;
    }

    private boolean putMap(Object key, Object value) {
        if (this.target instanceof Map) {
            ((Map)this.target).put(key, value);
            return true;
        }
        this.noSet();
        return false;
    }

    public boolean set(String key, Object value) {
        Class<?> clazz = this.target.getClass();
        Field f = this.findField(key, clazz);
        if (f != null) {
            try {
                f.set(this.target, this.quackContext.coerceJavaScriptToJava(f.getType(), value));
                return true;
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
        }
        Method s = JavaObject.getSetterMethod(key, clazz.getMethods());
        if (s != null) {
            try {
                this.quackContext.coerceJavaToJavaScript(s.invoke(this.target, this.quackContext.coerceJavaScriptToJava(s.getParameterTypes()[0], value)));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
            return true;
        }
        return this.putMap(key, value);
    }

    @Override
    public boolean set(Object key, Object value) {
        Number number;
        if (key instanceof Number && (number = (Number)key).doubleValue() == (double)number.intValue()) {
            return this.set(number.intValue(), value);
        }
        if (key instanceof String) {
            return this.set((String)key, value);
        }
        return this.putMap(key, value);
    }

    @Override
    public Object callMethod(Object thiz, Object ... args) {
        throw new UnsupportedOperationException("can not call " + this.target);
    }

    public Object callProperty(Object property, Object ... args) {
        if (property == null) {
            throw new NullPointerException();
        }
        if ((property = this.get(property)) instanceof QuackObject) {
            return ((QuackObject)property).callMethod(this, args);
        }
        throw new UnsupportedOperationException("can not call " + this.target);
    }

    @Override
    public Object construct(Object ... args) {
        if (!(this.target instanceof Class)) {
            return QuackObject.super.construct(args);
        }
        Class clazz = (Class)this.target;
        Object[] constructors = clazz.getConstructors();
        if (constructors.length == 0) {
            try {
                return clazz.newInstance();
            }
            catch (Exception e) {
                return new IllegalArgumentException(e);
            }
        }
        ArrayList argTypes = new ArrayList();
        for (Object arg : args) {
            if (arg == null) {
                argTypes.add(null);
                continue;
            }
            argTypes.add(arg.getClass());
        }
        Constructor best = QuackContext.javaObjectConstructorCandidates.memoize(() -> JavaObject.lambda$construct$4((Constructor[])constructors, argTypes), this.target, constructors, argTypes.toArray());
        try {
            int i;
            int numParameters = best.getParameterTypes().length;
            if (best.isVarArgs()) {
                --numParameters;
            }
            ArrayList<Object> coerced = new ArrayList<Object>();
            for (i = 0; i < numParameters; ++i) {
                if (i < args.length) {
                    coerced.add(this.quackContext.coerceJavaScriptToJava(best.getParameterTypes()[i], args[i]));
                    continue;
                }
                coerced.add(null);
            }
            if (best.isVarArgs()) {
                Class<?> varargType = best.getParameterTypes()[numParameters].getComponentType();
                ArrayList<Object> varargs = new ArrayList<Object>();
                while (i < args.length) {
                    varargs.add(this.quackContext.coerceJavaScriptToJava(varargType, args[i]));
                    ++i;
                }
                coerced.add(JavaMethodObject.toArray(varargType, varargs));
            } else if (i < args.length) {
                System.err.println("dropping javascript to java arguments on the floor: " + (args.length - i) + " " + best.toString());
            }
            return this.quackContext.coerceJavaToJavaScript(best.newInstance(coerced.toArray()));
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(best.toString(), e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new IllegalArgumentException(best.toString(), e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(best.toString(), e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(best.toString(), e);
        }
    }

    private static /* synthetic */ Constructor lambda$construct$4(Constructor[] constructors, ArrayList argTypes) {
        Constructor ret = null;
        int bestScore = Integer.MAX_VALUE;
        for (Constructor constructor : constructors) {
            int score = Math.abs(argTypes.size() - constructor.getParameterTypes().length) * 1000;
            for (int i = 0; i < Math.min(constructor.getParameterTypes().length, argTypes.size()); ++i) {
                Class argType = (Class)argTypes.get(i);
                Class<?> paramType = constructor.getParameterTypes()[i];
                if (paramType == argType) {
                    score -= 4;
                }
                if (QuackContext.isNumberClass(paramType) && QuackContext.isNumberClass(argType)) {
                    score -= 3;
                    continue;
                }
                if ((paramType == Long.class || paramType == Long.TYPE) && argType == String.class) {
                    score -= 2;
                    continue;
                }
                if (argType != null && !paramType.isAssignableFrom(argType)) continue;
                --score;
            }
            if (score >= bestScore) continue;
            bestScore = score;
            ret = constructor;
        }
        return ret;
    }
}

