/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.quack;

import com.koushikdutta.quack.JavaScriptObject;
import com.koushikdutta.quack.QuackContext;
import com.koushikdutta.quack.QuackMethodCoercion;
import com.koushikdutta.quack.QuackMethodName;
import com.koushikdutta.quack.QuackMethodObject;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;

public class JavaMethodObject
implements QuackMethodObject {
    String target;
    QuackContext quackContext;
    Object originalThis;

    public JavaMethodObject(QuackContext quackContext, Object originalThis, String method) {
        this.quackContext = quackContext;
        this.originalThis = originalThis;
        this.target = method;
    }

    protected Object getThis(Object thiz, Method method) {
        return thiz;
    }

    protected Method[] getMethods(Object thiz) {
        Method[] methods = thiz.getClass().getMethods();
        if (!(thiz instanceof Class)) {
            return methods;
        }
        ArrayList arr = new ArrayList();
        Collections.addAll(arr, methods);
        Collections.addAll(arr, ((Class)thiz).getMethods());
        return arr.toArray(new Method[0]);
    }

    @Override
    public Object callMethod(Object thiz, Object ... args) {
        if (thiz == null || thiz instanceof JavaScriptObject) {
            thiz = this.originalThis;
        }
        if (thiz == null) {
            throw new UnsupportedOperationException("can not call " + this.target);
        }
        thiz = this.quackContext.coerceJavaScriptToJava(Object.class, thiz);
        Object[] thisMethods = this.getMethods(thiz);
        ArrayList argTypes = new ArrayList();
        for (Object arg : args) {
            if (arg == null) {
                argTypes.add(null);
                continue;
            }
            argTypes.add(arg.getClass());
        }
        Method best = QuackContext.javaObjectMethodCandidates.memoize(() -> this.lambda$callMethod$0((Method[])thisMethods, argTypes), (Object)this.target, thisMethods, argTypes.toArray());
        if (best == null) {
            throw new UnsupportedOperationException("can not call " + this.target);
        }
        thiz = this.getThis(thiz, best);
        try {
            int i;
            Method interfaceMethod = QuackContext.getInterfaceMethod(best);
            QuackMethodCoercion methodCoercion = this.quackContext.JavaScriptToJavaMethodCoercions.get(interfaceMethod);
            if (methodCoercion != null) {
                return methodCoercion.invoke(interfaceMethod, thiz, args);
            }
            int numParameters = best.getParameterTypes().length;
            if (best.isVarArgs()) {
                --numParameters;
            }
            ArrayList<Object> coerced = new ArrayList<Object>();
            for (i = 0; i < numParameters; ++i) {
                if (i < args.length) {
                    coerced.add(this.quackContext.coerceJavaScriptToJava(best.getParameterTypes()[i], args[i]));
                    continue;
                }
                coerced.add(null);
            }
            if (best.isVarArgs()) {
                Class<?> varargType = best.getParameterTypes()[numParameters].getComponentType();
                ArrayList<Object> varargs = new ArrayList<Object>();
                while (i < args.length) {
                    varargs.add(this.quackContext.coerceJavaScriptToJava(varargType, args[i]));
                    ++i;
                }
                coerced.add(JavaMethodObject.toArray(varargType, varargs));
            } else if (i < args.length) {
                System.err.println("dropping javascript to java arguments on the floor: " + (args.length - i) + " " + best.toString());
            }
            return this.quackContext.coerceJavaToJavaScript(best.invoke(thiz, coerced.toArray()));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw new RuntimeException(e.getTargetException());
        }
    }

    static <T> T[] toArray(Class<T> varargType, ArrayList<T> varargs) {
        return varargs.toArray((Object[])Array.newInstance(varargType, 0));
    }

    private /* synthetic */ Method lambda$callMethod$0(Method[] thisMethods, ArrayList argTypes) {
        Method ret = null;
        int bestScore = Integer.MAX_VALUE;
        for (Method method : thisMethods) {
            QuackMethodName annotation;
            if (!method.getName().equals(this.target) && ((annotation = method.getAnnotation(QuackMethodName.class)) == null || !annotation.name().equals(this.target))) continue;
            int score = Math.abs(argTypes.size() - method.getParameterTypes().length) * 1000;
            for (int i = 0; i < Math.min(method.getParameterTypes().length, argTypes.size()); ++i) {
                Class argType = (Class)argTypes.get(i);
                Class<?> paramType = method.getParameterTypes()[i];
                if (paramType == argType) {
                    score -= 4;
                }
                if (QuackContext.isNumberClass(paramType) && QuackContext.isNumberClass(argType)) {
                    score -= 3;
                    continue;
                }
                if ((paramType == Long.class || paramType == Long.TYPE) && argType == String.class) {
                    score -= 2;
                    continue;
                }
                if (argType != null && !paramType.isAssignableFrom(argType)) continue;
                --score;
            }
            if (score >= bestScore) continue;
            bestScore = score;
            ret = method;
        }
        return ret;
    }
}

