/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.quack;

import com.koushikdutta.quack.JavaObject;
import com.koushikdutta.quack.JavaScriptObject;
import com.koushikdutta.quack.QuackContext;
import com.koushikdutta.quack.QuackJavaObject;
import com.koushikdutta.quack.QuackObject;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class JSValue
implements QuackJavaObject {
    QuackContext quack;
    Object value;

    JSValue(QuackContext quack, Object value) {
        this.quack = quack;
        this.value = value;
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    public boolean isNumber() {
        return this.value instanceof Number;
    }

    public boolean isString() {
        return this.value instanceof String;
    }

    public boolean isJavaScriptObject() {
        return this.value instanceof JavaScriptObject;
    }

    public boolean isByteBuffer() {
        return this.value instanceof ByteBuffer;
    }

    public boolean isNullOrUndefined() {
        return this.value == null;
    }

    public <T> T as(Class<T> clazz) {
        return (T)this.quack.coerceJavaScriptToJava(clazz, this.value);
    }

    public <T> Iterable<T> asIterable(final Class<T> clazz) {
        JSValue iteratorSymbol = this.quack.evaluateForJavaScriptObject("Symbol").asJSValue().get("iterator");
        JSValue iteratorFunc = this.get(iteratorSymbol);
        final JSValue iterator = iteratorFunc.apply(this, new Object[0]);
        final JSValue iteratorNext = iterator.get("next");
        return () -> new Iterator<T>(){
            JSValue current;

            private void maybeNext() {
                if (this.current != null) {
                    return;
                }
                this.current = iteratorNext.apply(iterator, new Object[0]);
            }

            @Override
            public boolean hasNext() {
                this.maybeNext();
                return (Boolean)this.current.get("done").getObject() == false;
            }

            @Override
            public T next() {
                this.maybeNext();
                if (((Boolean)this.current.get("done").getObject()).booleanValue()) {
                    throw new NoSuchElementException("end of iterator");
                }
                Object ret = this.current.get("value").as(clazz);
                this.current = null;
                return ret;
            }
        };
    }

    private QuackObject quackify() {
        if (this.value instanceof QuackObject) {
            return (QuackObject)this.value;
        }
        return new JavaObject(this.quack, this.value);
    }

    public JSValue get(Object key) {
        return new JSValue(this.quack, this.quackify().get(key));
    }

    public boolean set(Object key, Object value) {
        return this.quackify().set(key, value);
    }

    public boolean has(Object key) {
        return this.quackify().has(key);
    }

    public JSValue apply(Object thiz, Object ... args) {
        return new JSValue(this.quack, this.quackify().callMethod(thiz, args));
    }

    public JSValue construct(Object ... args) {
        return new JSValue(this.quack, this.quackify().construct(args));
    }

    public String toString() {
        if (this.value == null) {
            return "null";
        }
        return this.value.toString();
    }
}

