/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem.junit5;

import io.wcm.testing.mock.aem.junit5.AemContext;
import io.wcm.testing.mock.aem.junit5.AemContextExtension;
import io.wcm.testing.mock.aem.junit5.ResourceResolverMockAemContext;
import java.lang.reflect.Constructor;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;

final class AemContextStore {
    private static final ExtensionContext.Namespace AEM_CONTEXT_NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{AemContextExtension.class});
    private static final Class<ResourceResolverMockAemContext> DEFAULT_AEM_CONTEXT_TYPE = ResourceResolverMockAemContext.class;

    private AemContextStore() {
    }

    public static AemContext getAemContext(ExtensionContext extensionContext, Object testInstance) {
        return (AemContext)((Object)AemContextStore.getStore(extensionContext).get(testInstance, AemContext.class));
    }

    public static AemContext getOrCreateAemContext(ExtensionContext extensionContext, Object testInstance, Optional<Class<?>> aemContextType) {
        AemContext context = AemContextStore.getAemContext(extensionContext, testInstance);
        if (context == null) {
            context = AemContextStore.createAemContext(extensionContext, aemContextType);
            AemContextStore.storeAemContext(extensionContext, testInstance, context);
        }
        return context;
    }

    public static void removeAemContext(ExtensionContext extensionContext, Object testInstance) {
        AemContextStore.getStore(extensionContext).remove(testInstance);
    }

    public static void storeAemContext(ExtensionContext extensionContext, Object testInstance, AemContext aemContext) {
        AemContextStore.getStore(extensionContext).put(testInstance, (Object)aemContext);
    }

    private static ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(AEM_CONTEXT_NAMESPACE);
    }

    private static AemContext createAemContext(ExtensionContext extensionContext, Optional<Class<?>> aemContextType) {
        Class<ResourceResolverMockAemContext> type = aemContextType.orElse(DEFAULT_AEM_CONTEXT_TYPE);
        if (type == AemContext.class) {
            type = DEFAULT_AEM_CONTEXT_TYPE;
        }
        try {
            Constructor<ResourceResolverMockAemContext> constructor = type.getConstructor(new Class[0]);
            AemContext aemContext = constructor.newInstance(new Object[0]);
            aemContext.setUpContext();
            return aemContext;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not create " + type.getName() + " instance.", ex);
        }
    }
}

