/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem.junit5;

import io.wcm.testing.mock.aem.junit5.AemContext;
import io.wcm.testing.mock.aem.junit5.AemContextStore;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.sling.testing.mock.osgi.context.OsgiContextImpl;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;

public final class AemContextExtension
implements ParameterResolver,
TestInstancePostProcessor,
BeforeEachCallback,
AfterEachCallback,
AfterTestExecutionCallback {
    public void postProcessTestInstance(Object testInstance, ExtensionContext extensionContext) throws Exception {
        Field aemContextField = this.getFieldFromTestInstance(testInstance, AemContext.class);
        if (aemContextField != null) {
            AemContext context = (AemContext)((Object)aemContextField.get(testInstance));
            if (context != null) {
                if (!context.isSetUp()) {
                    context.setUpContext();
                }
                AemContextStore.storeAemContext(extensionContext, testInstance, context);
            } else {
                context = AemContextStore.getOrCreateAemContext(extensionContext, testInstance, Optional.of(aemContextField.getType()));
                aemContextField.set(testInstance, (Object)context);
            }
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return AemContext.class.isAssignableFrom(parameterContext.getParameter().getType());
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        AemContext aemContext = AemContextStore.getOrCreateAemContext(extensionContext, extensionContext.getRequiredTestInstance(), this.getAemContextType(parameterContext, extensionContext));
        if (this.paramIsNotInstanceOfExistingContext(parameterContext, aemContext)) {
            throw new ParameterResolutionException("Found AemContext instance of type: " + ((Object)((Object)aemContext)).getClass().getName() + "\nRequired is: " + parameterContext.getParameter().getType().getName() + "\nVerify that all test lifecycle methods (@BeforeEach, @Test, @AfterEach) use the same AemContext type.");
        }
        return aemContext;
    }

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        this.applyAemContext(extensionContext, aemContext -> aemContext.getContextPlugins().executeAfterSetUpCallback((OsgiContextImpl)aemContext));
    }

    public void afterTestExecution(ExtensionContext extensionContext) throws Exception {
        this.applyAemContext(extensionContext, aemContext -> aemContext.getContextPlugins().executeBeforeTearDownCallback((OsgiContextImpl)aemContext));
    }

    public void afterEach(ExtensionContext extensionContext) {
        this.applyAemContext(extensionContext, aemContext -> {
            aemContext.getContextPlugins().executeAfterTearDownCallback((OsgiContextImpl)aemContext);
            aemContext.tearDownContext();
            AemContextStore.removeAemContext(extensionContext, extensionContext.getRequiredTestInstance());
        });
    }

    private void applyAemContext(ExtensionContext extensionContext, Consumer<AemContext> consumer) {
        AemContext aemContext = AemContextStore.getAemContext(extensionContext, extensionContext.getRequiredTestInstance());
        if (aemContext != null) {
            consumer.accept(aemContext);
        }
    }

    private Optional<Class<?>> getAemContextType(ParameterContext parameterContext, ExtensionContext extensionContext) {
        if (this.isAbstractAemContext(parameterContext)) {
            return this.getParameterFromTestMethod(extensionContext, AemContext.class);
        }
        return Optional.of(parameterContext.getParameter().getType());
    }

    private boolean isAbstractAemContext(ParameterContext parameterContext) {
        return parameterContext.getParameter().getType().equals(AemContext.class);
    }

    private boolean paramIsNotInstanceOfExistingContext(ParameterContext parameterContext, AemContext aemContext) {
        return !parameterContext.getParameter().getType().isInstance((Object)aemContext);
    }

    private Optional<Class<?>> getParameterFromTestMethod(ExtensionContext extensionContext, Class<?> type) {
        return Arrays.stream(extensionContext.getRequiredTestMethod().getParameterTypes()).filter(clazz -> type.isAssignableFrom((Class<?>)clazz)).findFirst();
    }

    private Field getFieldFromTestInstance(Object testInstance, Class<?> type) {
        Field contextField = Arrays.stream(testInstance.getClass().getDeclaredFields()).filter(field -> type.isAssignableFrom(field.getType())).findFirst().orElse(null);
        if (contextField != null) {
            contextField.setAccessible(true);
        }
        return contextField;
    }
}

