/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem.context;

import java.lang.reflect.Method;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.sling.resourceresolver.impl.ResourceResolverFactoryConfig;

final class ResourceResolverFactoryConfigPropertyNames {
    private static final String VANITY_PATH_ALLOW_LIST_PROPERTY_NAME;
    private static final String VANITY_PATH_DENY_LIST_PROPERTY_NAME;

    static String getVanityPathAllowListPropertyName() {
        return VANITY_PATH_ALLOW_LIST_PROPERTY_NAME;
    }

    static String getVanityPathDenyListPropertyName() {
        return VANITY_PATH_DENY_LIST_PROPERTY_NAME;
    }

    private ResourceResolverFactoryConfigPropertyNames() {
    }

    static {
        String vanityPathAllowListPropertyName = "resource.resolver.vanitypath.whitelist";
        String vanityPathDenyListPropertyName = "resource.resolver.vanitypath.blacklist";
        try {
            Class<?> resourceResolverFactoryConfigClass = Class.forName(ResourceResolverFactoryConfig.class.getName());
            Set methodNames = Stream.of(resourceResolverFactoryConfigClass.getDeclaredMethods()).map(Method::getName).collect(Collectors.toSet());
            if (methodNames.contains("resource_resolver_vanitypath_allowlist") && methodNames.contains("resource_resolver_vanitypath_denylist")) {
                vanityPathAllowListPropertyName = "resource.resolver.vanitypath.allowlist";
                vanityPathDenyListPropertyName = "resource.resolver.vanitypath.denylist";
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        VANITY_PATH_ALLOW_LIST_PROPERTY_NAME = vanityPathAllowListPropertyName;
        VANITY_PATH_DENY_LIST_PROPERTY_NAME = vanityPathDenyListPropertyName;
    }
}

