/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import com.day.cq.wcm.api.Template;
import java.util.Calendar;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.jetbrains.annotations.NotNull;

class MockTemplate
extends ResourceWrapper
implements Template {
    static final String NN_INITIAL = "initial";
    static final String NN_STRUCTURE = "structure";
    static final String NN_POLICIES = "policies";
    private final Resource resource;
    private final ValueMap properties;

    MockTemplate(@NotNull Resource resource) {
        super(resource);
        this.resource = resource;
        this.properties = this.hasStructureSupport() ? ResourceUtil.getValueMap((Resource)resource.getChild("jcr:content")) : ResourceUtil.getValueMap((Resource)resource);
    }

    public String getPath() {
        return super.getPath();
    }

    public String getName() {
        return super.getName();
    }

    public String getTitle() {
        return (String)this.properties.get("jcr:title", String.class);
    }

    public String getShortTitle() {
        return (String)this.properties.get("shortTitle", String.class);
    }

    public String getDescription() {
        return (String)this.properties.get("jcr:description", String.class);
    }

    public String getIconPath() {
        Resource iconResource = this.resource.getChild("icon.png");
        if (iconResource != null) {
            return iconResource.getPath();
        }
        return null;
    }

    public String getThumbnailPath() {
        Resource thumbnailResource = this.resource.getChild("thumbnail.png");
        if (thumbnailResource != null) {
            return thumbnailResource.getPath();
        }
        return null;
    }

    public Long getRanking() {
        return (Long)this.properties.get("ranking", Long.class);
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public Calendar getLastModified() {
        return (Calendar)this.properties.get("jcr:lastModified", Calendar.class);
    }

    public ValueMap getProperties() {
        return this.properties;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MockTemplate)) {
            return false;
        }
        return StringUtils.equals((CharSequence)this.getPath(), (CharSequence)((MockTemplate)((Object)obj)).getPath());
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == Resource.class) {
            return (AdapterType)this.getResource();
        }
        return (AdapterType)super.adaptTo(type);
    }

    public boolean hasStructureSupport() {
        return this.resource.getChild(NN_STRUCTURE) != null;
    }

    public String getInitialContentPath() {
        Resource initialContentResource = this.hasStructureSupport() ? this.resource.getChild("initial/jcr:content") : this.resource.getChild("jcr:content");
        if (initialContentResource != null) {
            return initialContentResource.getPath();
        }
        return null;
    }

    public boolean isAllowed(String parentPath) {
        throw new UnsupportedOperationException();
    }

    public boolean isAllowedChild(Template template) {
        throw new UnsupportedOperationException();
    }

    public void write(JSONWriter jsonWriter) throws JSONException {
        throw new UnsupportedOperationException();
    }

    public String getPageTypePath() {
        throw new UnsupportedOperationException();
    }

    public boolean isAllowed(Resource arg0) {
        throw new UnsupportedOperationException();
    }
}

