/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import com.day.cq.commons.Doctype;
import com.day.cq.wcm.api.designer.Cell;
import com.day.cq.wcm.api.designer.ComponentStyle;
import com.day.cq.wcm.api.designer.Design;
import com.day.cq.wcm.api.designer.Style;
import com.day.cq.wcm.api.policies.ContentPolicy;
import com.day.cq.wcm.api.policies.ContentPolicyManager;
import io.wcm.testing.mock.aem.MockCell;
import io.wcm.testing.mock.aem.MockContentPolicyManager;
import io.wcm.testing.mock.aem.MockStyle;
import java.io.IOException;
import java.io.Writer;
import java.util.Calendar;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.servlet.jsp.PageContext;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;

class MockDesign
implements Design {
    private final Style emptyStyle = new MockStyle(ValueMap.EMPTY, this);
    private final ResourceResolver resourceResolver;

    MockDesign(ResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
    }

    public Style getStyle(String path) {
        Resource resource = this.resourceResolver.getResource(path);
        if (resource != null) {
            return this.getStyle(resource);
        }
        return this.emptyStyle;
    }

    public Style getStyle(Cell cell) {
        if (cell instanceof MockCell) {
            Resource resource = ((MockCell)cell).getComponentContext().getResource();
            return this.getStyle(resource);
        }
        return this.emptyStyle;
    }

    public Style getStyle(Resource resource) {
        Resource unwrappedResource;
        ContentPolicy policy;
        ContentPolicyManager contentPolicyManager = (ContentPolicyManager)resource.getResourceResolver().adaptTo(ContentPolicyManager.class);
        if (contentPolicyManager instanceof MockContentPolicyManager && (policy = ((MockContentPolicyManager)contentPolicyManager).getPolicy(unwrappedResource = ResourceUtil.unwrap((Resource)resource))) != null) {
            return new MockStyle(policy.getProperties(), this);
        }
        return this.emptyStyle;
    }

    public Style getStyle(Resource resource, boolean ignoreExcludedComponents) {
        return this.getStyle(resource);
    }

    public String getPath() {
        return "/etc/designs/default";
    }

    public Map<String, ComponentStyle> getComponentStyles(Cell cell) {
        throw new UnsupportedOperationException();
    }

    public Resource getContentResource() {
        throw new UnsupportedOperationException();
    }

    public String getCssPath() {
        throw new UnsupportedOperationException();
    }

    public Doctype getDoctype(Style style) {
        throw new UnsupportedOperationException();
    }

    public String getId() {
        throw new UnsupportedOperationException();
    }

    public String getJSON() {
        throw new UnsupportedOperationException();
    }

    public Calendar getLastModified() {
        throw new UnsupportedOperationException();
    }

    public String getStaticCssPath() {
        throw new UnsupportedOperationException();
    }

    public boolean hasContent() {
        throw new UnsupportedOperationException();
    }

    public void writeCSS(Writer writer, boolean includeCustom) throws IOException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void writeCssIncludes(Writer writer) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeCssIncludes(PageContext pageContext) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeCssIncludes(Writer writer, Doctype doctype) throws IOException {
        throw new UnsupportedOperationException();
    }
}

