/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import com.day.cq.wcm.api.Template;
import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.api.policies.ContentPolicy;
import com.day.cq.wcm.api.policies.ContentPolicyManager;
import com.day.cq.wcm.api.policies.ContentPolicyMapping;
import io.wcm.testing.mock.aem.MockContentPolicyStorage;
import java.util.List;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MockContentPolicyManager
implements ContentPolicyManager {
    private final ResourceResolver resourceResolver;

    MockContentPolicyManager(@NotNull ResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
    }

    public ContentPolicy getPolicy(@NotNull ComponentContext componentContext) {
        return this.getPolicy(componentContext.getResource());
    }

    public ContentPolicyMapping getPolicyMapping(Resource contentResource) {
        String resourceType = contentResource.getResourceType();
        if (StringUtils.isNotBlank((CharSequence)resourceType)) {
            return MockContentPolicyStorage.getContentPolicyMapping(resourceType, this.resourceResolver);
        }
        return null;
    }

    public ContentPolicy getPolicy(@NotNull Resource contentResource) {
        ContentPolicyMapping mapping = this.getPolicyMapping(contentResource);
        if (mapping != null) {
            return mapping.getPolicy();
        }
        return null;
    }

    @Nullable
    public ContentPolicy getPolicy(@NotNull Resource contentResource, @Nullable SlingHttpServletRequest request) {
        return this.getPolicy(contentResource);
    }

    public List<ContentPolicy> getPolicies(String path) {
        throw new UnsupportedOperationException();
    }

    public List<ContentPolicy> getPolicies(String path, String policyResourceType) {
        throw new UnsupportedOperationException();
    }

    public ContentPolicy copyPolicy(ContentPolicy originalPolicy, String newTitle, String newDescription) {
        throw new UnsupportedOperationException();
    }

    public List<ContentPolicyMapping> getPolicyMappings(ContentPolicy contentPolicy) {
        throw new UnsupportedOperationException();
    }

    public String getPolicyLocation(Resource resource) {
        throw new UnsupportedOperationException();
    }

    public List<Template> getTemplates(String policyAbsolutePath) {
        throw new UnsupportedOperationException();
    }

    public List<Template> getTemplates(String policyAbsolutePath, Predicate filter) {
        throw new UnsupportedOperationException();
    }

    public boolean isPolicyUsed(String arg0, @Nullable Predicate filter) {
        throw new UnsupportedOperationException();
    }

    public List<Template> getTemplates(String policyAbsolutePath, @Nullable java.util.function.Predicate filter) {
        throw new UnsupportedOperationException();
    }

    public boolean isPolicyUsed(String policyAbsolutePath, @Nullable java.util.function.Predicate filter) {
        throw new UnsupportedOperationException();
    }
}

