/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.WCMMode;
import com.day.cq.wcm.api.components.AnalyzeContext;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.api.components.ComponentManager;
import com.day.cq.wcm.api.components.EditContext;
import com.day.cq.wcm.api.designer.Cell;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.wcm.testing.mock.aem.MockCell;
import io.wcm.testing.mock.aem.MockEditContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;

public final class MockComponentContext
implements ComponentContext {
    private final Page currentPage;
    private final SlingHttpServletRequest request;
    private final EditContext editContext;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private boolean decorate = true;
    private String decorationTagName;
    private String defaultDecorationTagName;
    private Cell cell;
    private Set<String> cssClassNames = Collections.emptySet();

    public MockComponentContext(@NotNull Page currentPage, @NotNull SlingHttpServletRequest request) {
        this.currentPage = currentPage;
        this.request = request;
        boolean hasEditContext = WCMMode.fromRequest((ServletRequest)request) != WCMMode.DISABLED;
        this.editContext = hasEditContext ? new MockEditContext(this) : null;
        this.cell = new MockCell(this);
    }

    public Page getPage() {
        return this.currentPage;
    }

    public Resource getResource() {
        return this.request.getResource();
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    public Component getComponent() {
        Resource currentResource = this.getResource();
        if (currentResource == null) {
            return null;
        }
        ComponentManager componentManager = (ComponentManager)currentResource.getResourceResolver().adaptTo(ComponentManager.class);
        if (componentManager == null) {
            throw new IllegalStateException("No component manager.");
        }
        return componentManager.getComponentOfResource(currentResource);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Object setAttribute(String name, Object value) {
        return this.attributes.put(name, value);
    }

    public boolean hasDecoration() {
        return this.decorate;
    }

    public void setDecorate(boolean decorate) {
        this.decorate = decorate;
    }

    public String getDecorationTagName() {
        return this.decorationTagName;
    }

    public void setDecorationTagName(String value) {
        this.decorationTagName = value;
    }

    public String getDefaultDecorationTagName() {
        return this.defaultDecorationTagName;
    }

    public void setDefaultDecorationTagName(String value) {
        this.defaultDecorationTagName = value;
    }

    public EditContext getEditContext() {
        return this.editContext;
    }

    public Cell getCell() {
        return this.cell;
    }

    public void setCell(Cell cell) {
        this.cell = cell;
    }

    public Set<String> getCssClassNames() {
        return this.cssClassNames;
    }

    public void setCssClassNames(Set<String> cssClassNames) {
        this.cssClassNames = cssClassNames;
    }

    public ComponentContext getParent() {
        return null;
    }

    public ComponentContext getRoot() {
        return this;
    }

    public boolean isRoot() {
        return true;
    }

    public AnalyzeContext getAnalyzeContext() {
        throw new UnsupportedOperationException();
    }
}

