/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.siteapi.integrationtestsupport.linkextractor;

import com.jayway.jsonpath.Criteria;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import io.wcm.siteapi.integrationtestsupport.linkextractor.LinkExtractor;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public final class RichTextInternalLinks
implements LinkExtractor {
    private static final Set<String> SUFFIXES = Set.of("content");
    private final JsonPath jsonPath;

    public RichTextInternalLinks(String ... resourceTypes) {
        this(Arrays.asList(resourceTypes));
    }

    public RichTextInternalLinks(List<String> resourceTypes) {
        this.jsonPath = JsonPath.compile((String)"$..[?]", (Predicate[])new Predicate[]{Filter.filter((Predicate)Criteria.where((String)":type").in(resourceTypes).and("text").exists(true))});
    }

    @Override
    public boolean accept(String suffix) {
        return SUFFIXES.contains(suffix);
    }

    @Override
    public Stream<String> getLinks(DocumentContext jsonPathContext) {
        List richTextComponents = (List)jsonPathContext.read(this.jsonPath);
        return richTextComponents.stream().map(entry -> (String)entry.get("text")).flatMap(this::extractLinksFromHtmlFragment);
    }

    private Stream<String> extractLinksFromHtmlFragment(String html) {
        Document document = Jsoup.parse((String)html);
        return document.select("a[data-type='internal']").stream().map(a -> a.attr("href"));
    }
}

