/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.siteapi.integrationtestsupport.linkextractor;

import com.jayway.jsonpath.Criteria;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import io.wcm.siteapi.integrationtestsupport.linkextractor.LinkExtractor;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;

public final class ContentInternalLinks
implements LinkExtractor {
    private static final Set<String> SUFFIXES = Set.of("content", "navigation", "config");
    private static final JsonPath JSON_PATH = JsonPath.compile((String)"$..[?]", (Predicate[])new Predicate[]{Filter.filter((Predicate)Criteria.where((String)"url").exists(true).and("type").is((Object)"internal"))});

    @Override
    public boolean accept(String suffix) {
        return SUFFIXES.contains(suffix);
    }

    @Override
    public Stream<String> getLinks(DocumentContext jsonPathContext) {
        List contentLinkObjects = (List)jsonPathContext.read(JSON_PATH);
        return contentLinkObjects.stream().map(item -> (String)item.get("url"));
    }
}

