/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.siteapi.integrationtestsupport.crawler;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

class UrlParser {
    private static final int GROUP_SUFFIX = 1;
    private final Pattern urlPattern;

    UrlParser(@NotNull String publishUrl, @NotNull String selector, @NotNull String apiVersion, @NotNull String extension) {
        this.urlPattern = Pattern.compile("^" + Pattern.quote(publishUrl) + "/.+\\." + Pattern.quote(selector) + (String)(StringUtils.isNotBlank((CharSequence)apiVersion) ? "\\." + Pattern.quote(apiVersion) : "") + "\\." + Pattern.quote(extension) + "/([^/]+)(/(.*))?\\.json$");
    }

    String parseSuffix(@NotNull String url) {
        Matcher matcher = this.urlPattern.matcher(url);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid URL: " + url + ", expected pattern: " + String.valueOf(this.urlPattern));
        }
        return matcher.group(1);
    }
}

