/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.siteapi.integrationtestsupport;

import io.wcm.siteapi.integrationtestsupport.IntegrationTestContext;
import io.wcm.siteapi.openapi.validator.OpenApiSpecVersions;
import java.time.Duration;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IntegrationTestContextBuilder {
    private String publishUrl;
    private String selector = "site";
    private String apiVersion = "";
    private String extension = "api";
    private OpenApiSpecVersions specVersions;
    private Duration httpConnectTimeout = Duration.ofSeconds(20L);
    private Duration httpRequestTimeout = Duration.ofSeconds(60L);

    @Nullable
    public String getPublishUrl() {
        return this.publishUrl;
    }

    @NotNull
    public IntegrationTestContextBuilder publishUrl(@NotNull String value) {
        this.publishUrl = StringUtils.removeEnd((String)value, (String)"/");
        return this;
    }

    @NotNull
    public String getSelector() {
        return this.selector;
    }

    @NotNull
    public IntegrationTestContextBuilder selector(@NotNull String value) {
        this.selector = value;
        return this;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    @NotNull
    public IntegrationTestContextBuilder apiVersion(@NotNull String value) {
        this.apiVersion = value;
        return this;
    }

    @NotNull
    public String getExtension() {
        return this.extension;
    }

    @NotNull
    public IntegrationTestContextBuilder extension(@NotNull String value) {
        this.extension = value;
        return this;
    }

    @NotNull
    public OpenApiSpecVersions getSpecVersions() {
        return this.specVersions;
    }

    @NotNull
    public IntegrationTestContextBuilder specVersions(@NotNull OpenApiSpecVersions value) {
        this.specVersions = value;
        return this;
    }

    @NotNull
    public Duration getHttpConnectTimeout() {
        return this.httpConnectTimeout;
    }

    @NotNull
    public IntegrationTestContextBuilder httpConnectTimeout(@NotNull Duration value) {
        this.httpConnectTimeout = value;
        return this;
    }

    @NotNull
    public Duration getHttpRequestTimeout() {
        return this.httpRequestTimeout;
    }

    @NotNull
    public IntegrationTestContextBuilder httpRequestTimeout(@NotNull Duration value) {
        this.httpRequestTimeout = value;
        return this;
    }

    @NotNull
    public IntegrationTestContext build() {
        if (this.publishUrl == null) {
            throw new IllegalArgumentException("No publish URL given.");
        }
        if (this.specVersions == null) {
            this.specVersions = new OpenApiSpecVersions();
        }
        return new IntegrationTestContext(this);
    }
}

