/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.siteapi.integrationtestsupport;

import io.wcm.siteapi.integrationtestsupport.IntegrationTestContextBuilder;
import io.wcm.siteapi.integrationtestsupport.httpclient.HttpClient;
import io.wcm.siteapi.openapi.validator.OpenApiSchemaValidator;
import io.wcm.siteapi.openapi.validator.OpenApiSpec;
import io.wcm.siteapi.openapi.validator.OpenApiSpecVersions;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public final class IntegrationTestContext {
    private final String publishUrl;
    private final String selector;
    private final String apiVersion;
    private final String extension;
    private final OpenApiSpecVersions specVersions;
    private final HttpClient httpClient;

    IntegrationTestContext(IntegrationTestContextBuilder builder) {
        this.publishUrl = builder.getPublishUrl();
        this.selector = builder.getSelector();
        this.apiVersion = builder.getApiVersion();
        this.extension = builder.getExtension();
        this.specVersions = builder.getSpecVersions();
        this.httpClient = new HttpClient(builder);
    }

    public String buildSiteApiUrl(@NotNull String path, @NotNull String suffix) {
        StringBuilder result = new StringBuilder();
        result.append(this.publishUrl).append(path).append(".").append(this.selector);
        if (!StringUtils.isEmpty((CharSequence)this.apiVersion)) {
            result.append(".").append(this.apiVersion);
        }
        result.append(".").append(this.extension).append("/").append(suffix).append(".json");
        return result.toString();
    }

    @NotNull
    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    @NotNull
    public Collection<String> getAllApiVersions() {
        return this.specVersions.getAllVersions();
    }

    @NotNull
    public OpenApiSchemaValidator getValidator(@NotNull String suffix) {
        OpenApiSpec spec = this.specVersions.get(this.apiVersion);
        return spec.getSchemaValidator(suffix);
    }

    @NotNull
    public String getPublishUrl() {
        return this.publishUrl;
    }

    @NotNull
    public String getSelector() {
        return this.selector;
    }

    @NotNull
    public String getApiVersion() {
        return this.apiVersion;
    }

    @NotNull
    public String getExtension() {
        return this.extension;
    }
}

