/*
 * #%L
 * wcm.io
 * %%
 * Copyright (C) 2023 wcm.io
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
package io.wcm.siteapi.integrationtestsupport.linkextractor;

import java.util.List;
import java.util.Set;
import java.util.stream.Stream;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;

/**
 * Extract links generated by the default output of <a href=
 * "https://github.com/wcm-io/io.wcm.site-api.processor/blob/develop/src/main/java/io/wcm/siteapi/processor/impl/index/IndexProcessor.java">Site
 * API Index Processor</a>.
 */
public final class IndexLinks implements LinkExtractor {

  private static final Set<String> SUFFIXES = Set.of("index");
  private static final JsonPath JSON_PATH = JsonPath.compile("$.[*].url");

  @Override
  public boolean accept(String suffix) {
    return SUFFIXES.contains(suffix);
  }

  @Override
  public Stream<String> getLinks(DocumentContext jsonPathContext) {
    List<String> urls = jsonPathContext.read(JSON_PATH);
    return urls.stream();
  }

}
