/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bootstrap;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import me.xdrop.fuzzywuzzy.FuzzySearch;

class FuzzyMatcher {
    private FuzzyMatcher() {
    }

    public static List<String> findSimilar(String key, Set<String> candidates, int count) {
        if (candidates.contains(key)) {
            throw new IllegalArgumentException("Key '%s' is already present in the %s candidates".formatted(key, candidates));
        }
        return (List)candidates.stream().map(candidate -> new Match((String)candidate, FuzzySearch.ratio((String)candidate, (String)key))).filter(match -> match.ratio() > 75).sorted(Comparator.comparingInt(Match::ratio).reversed()).limit(count).map(Match::key).collect(ImmutableList.toImmutableList());
    }

    private record Match(String key, int ratio) {
        public Match {
            Objects.requireNonNull(key, "key is null");
            Verify.verify((ratio >= 0 && ratio < 100 ? 1 : 0) != 0, (String)"ratio must be in the [0, 100) range", (Object[])new Object[0]);
        }
    }
}

