/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jaxrs;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.exc.StreamReadException;
import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.exc.PropertyBindingException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public class JacksonMapper
implements ExceptionMapper<JacksonException> {
    public Response toResponse(JacksonException exception) {
        JacksonException jacksonException = exception;
        Objects.requireNonNull(jacksonException);
        JacksonException jacksonException2 = jacksonException;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StreamReadException.class, PropertyBindingException.class, StreamWriteException.class, JsonMappingException.class}, (Object)jacksonException2, n)) {
            case 0 -> {
                StreamReadException streamReadException = (StreamReadException)jacksonException2;
                yield Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)JacksonMapper.formatErrorMessage((JsonProcessingException)streamReadException, "Could not read JSON value")).build();
            }
            case 1 -> {
                PropertyBindingException propertyBindingException = (PropertyBindingException)jacksonException2;
                yield Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)JacksonMapper.formatErrorMessage((JsonProcessingException)propertyBindingException, "Could not bind JSON value")).build();
            }
            case 2 -> {
                StreamWriteException streamWriteException = (StreamWriteException)jacksonException2;
                yield Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)JacksonMapper.formatErrorMessage((JsonProcessingException)streamWriteException, "Could not write JSON value")).build();
            }
            case 3 -> {
                JsonMappingException mappingException = (JsonMappingException)jacksonException2;
                yield Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Could not map JSON value: " + mappingException.getMessage())).build();
            }
            default -> Response.serverError().entity((Object)exception.getMessage()).build();
        };
    }

    private static String formatErrorMessage(JsonProcessingException e, String message) {
        return "%s: %s at location %s".formatted(message, e.getOriginalMessage(), e.getLocation());
    }
}

