/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.httpquery;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.configuration.ConfigBinder;
import io.airlift.http.server.HttpServerModule;
import io.airlift.http.server.testing.TestingHttpServerModule;
import io.airlift.jaxrs.JaxrsBinder;
import io.airlift.jaxrs.JaxrsModule;
import io.airlift.json.JsonCodecBinder;
import io.airlift.json.JsonModule;
import io.airlift.node.NodeInfo;
import io.trino.plugin.httpquery.HttpServerEventListener;
import io.trino.plugin.httpquery.HttpServerEventListenerConfig;
import io.trino.spi.eventlistener.EventListener;
import io.trino.spi.eventlistener.EventListenerFactory;
import io.trino.spi.eventlistener.QueryCompletedEvent;
import java.util.Map;

public class HttpServerEventListenerFactory
implements EventListenerFactory {
    public String getName() {
        return "http-server";
    }

    public EventListener create(Map<String, String> config) {
        return this.createInternal(config, false);
    }

    @VisibleForTesting
    HttpServerEventListener createInternal(Map<String, String> config, boolean testing) {
        Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new JaxrsModule(), testing ? new TestingHttpServerModule() : new HttpServerModule(), binder -> {
            JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(QueryCompletedEvent.class);
            ConfigBinder.configBinder((Binder)binder).bindConfig(HttpServerEventListenerConfig.class);
            binder.bind(HttpServerEventListener.class).in(Scopes.SINGLETON);
            JaxrsBinder.jaxrsBinder((Binder)binder).bind(HttpServerEventListener.class);
            binder.bind(NodeInfo.class).toInstance((Object)new NodeInfo("dummy"));
        }});
        Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
        return (HttpServerEventListener)injector.getInstance(HttpServerEventListener.class);
    }
}

