/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.event.client;

import java.lang.annotation.Annotation;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

final class AnnotationUtils {
    private AnnotationUtils() {
    }

    public static Collection<Method> findAnnotatedMethods(Class<?> clazz, Class<? extends Annotation> annotation) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : clazz.getMethods()) {
            Method managedMethod;
            if (method.isSynthetic() || method.isBridge() || Modifier.isStatic(method.getModifiers()) || (managedMethod = AnnotationUtils.findAnnotatedMethod(clazz, annotation, method.getName(), method.getParameterTypes())) == null) continue;
            result.add(managedMethod);
        }
        return result;
    }

    private static Method findAnnotatedMethod(Class<?> clazz, Class<? extends Annotation> annotation, String methodName, Class<?> ... paramTypes) {
        Method managedMethod;
        if (clazz.equals(Object.class)) {
            return null;
        }
        Method[] configClassMethods = clazz.getDeclaredMethods();
        for (Method method : configClassMethods) {
            if (!method.getName().equals(methodName) || !Arrays.equals(method.getParameterTypes(), paramTypes) || !method.isAnnotationPresent(annotation)) continue;
            return method;
        }
        if (clazz.getSuperclass() != null && (managedMethod = AnnotationUtils.findAnnotatedMethod(clazz.getSuperclass(), annotation, methodName, paramTypes)) != null) {
            return managedMethod;
        }
        for (GenericDeclaration genericDeclaration : clazz.getInterfaces()) {
            Method managedMethod2 = AnnotationUtils.findAnnotatedMethod(genericDeclaration, annotation, methodName, paramTypes);
            if (managedMethod2 == null) continue;
            return managedMethod2;
        }
        return null;
    }
}

