/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.discovery.client.AnnouncementHttpServerInfo;
import io.airlift.event.client.EventBinder;
import io.airlift.http.server.EnableCaseSensitiveHeaderCache;
import io.airlift.http.server.EnableLegacyUriCompliance;
import io.airlift.http.server.EnableVirtualThreads;
import io.airlift.http.server.HttpRequestEvent;
import io.airlift.http.server.HttpServer;
import io.airlift.http.server.HttpServerBinder;
import io.airlift.http.server.HttpServerConfig;
import io.airlift.http.server.HttpServerInfo;
import io.airlift.http.server.HttpServerProvider;
import io.airlift.http.server.HttpsConfig;
import io.airlift.http.server.LocalAnnouncementHttpServerInfo;
import io.airlift.http.server.RequestStats;
import io.airlift.http.server.TheAdminServlet;
import io.airlift.http.server.TheServlet;
import jakarta.servlet.Filter;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.weakref.jmx.guice.ExportBinder;

public class HttpServerModule
extends AbstractConfigurationAwareModule {
    public static final String REALM_NAME = "Airlift";

    protected void setup(Binder binder) {
        binder.disableCircularProxies();
        binder.bind(HttpServer.class).toProvider(HttpServerProvider.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, HttpServer.ClientCertificate.class).setDefault().toInstance((Object)HttpServer.ClientCertificate.NONE);
        ExportBinder.newExporter((Binder)binder).export(HttpServer.class).withGeneratedName();
        binder.bind(HttpServerInfo.class).in(Scopes.SINGLETON);
        binder.bind(RequestStats.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, (Key)Key.get(Boolean.class, EnableVirtualThreads.class)).setDefault().toInstance((Object)false);
        OptionalBinder.newOptionalBinder((Binder)binder, (Key)Key.get(Boolean.class, EnableLegacyUriCompliance.class)).setDefault().toInstance((Object)false);
        Multibinder.newSetBinder((Binder)binder, Filter.class, TheServlet.class);
        Multibinder.newSetBinder((Binder)binder, Filter.class, TheAdminServlet.class);
        Multibinder.newSetBinder((Binder)binder, HttpServerBinder.HttpResourceBinding.class, TheServlet.class);
        OptionalBinder.newOptionalBinder((Binder)binder, SslContextFactory.Server.class);
        OptionalBinder.newOptionalBinder((Binder)binder, (Key)Key.get(Boolean.class, EnableCaseSensitiveHeaderCache.class)).setDefault().toInstance((Object)false);
        ExportBinder.newExporter((Binder)binder).export(RequestStats.class).withGeneratedName();
        ConfigBinder.configBinder((Binder)binder).bindConfig(HttpServerConfig.class);
        OptionalBinder.newOptionalBinder((Binder)binder, HttpsConfig.class);
        EventBinder.eventBinder((Binder)binder).bindEventClient(new Class[]{HttpRequestEvent.class});
        binder.bind(AnnouncementHttpServerInfo.class).to(LocalAnnouncementHttpServerInfo.class).in(Scopes.SINGLETON);
        this.install(ConditionalModule.conditionalModule(HttpServerConfig.class, HttpServerConfig::isHttpsEnabled, moduleBinder -> ConfigBinder.configBinder((Binder)moduleBinder).bindConfig(HttpsConfig.class)));
    }
}

