/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.node;

import com.google.common.net.InetAddresses;
import java.lang.runtime.SwitchBootstraps;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import java.util.Optional;

public final class AddressToHostname {
    private static final String IP_ENCODED_SUFFIX = ".ip";

    private AddressToHostname() {
    }

    public static String encodeAddressAsHostname(InetAddress inetAddress) {
        InetAddress inetAddress2 = inetAddress;
        Objects.requireNonNull(inetAddress2);
        InetAddress inetAddress3 = inetAddress2;
        int n = 0;
        String hostname = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Inet4Address.class, Inet6Address.class}, (Object)inetAddress3, n)) {
            case 0 -> {
                Inet4Address inet4Address = (Inet4Address)inetAddress3;
                yield InetAddresses.toAddrString((InetAddress)inet4Address).replace('.', '-');
            }
            case 1 -> {
                Inet6Address inet6Address = (Inet6Address)inetAddress3;
                yield "x" + AddressToHostname.stripScopeId(InetAddresses.toAddrString((InetAddress)inet6Address)).replace(':', '-');
            }
            default -> InetAddresses.toAddrString((InetAddress)inetAddress);
        };
        return hostname + IP_ENCODED_SUFFIX;
    }

    private static String stripScopeId(String address) {
        int index = address.indexOf(37);
        if (index == -1) {
            return address;
        }
        return address.substring(0, index);
    }

    public static Optional<InetAddress> tryDecodeHostnameToAddress(String hostname) {
        if (!hostname.endsWith(IP_ENCODED_SUFFIX)) {
            return Optional.empty();
        }
        String ipString = hostname.substring(0, hostname.length() - IP_ENCODED_SUFFIX.length());
        ipString = ipString.startsWith("x") ? ipString.substring(1).replace('-', ':') : ipString.replace('-', '.');
        byte[] address = InetAddresses.forString((String)ipString).getAddress();
        try {
            return Optional.of(InetAddress.getByAddress(hostname, address));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

