/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Provider;
import io.airlift.http.server.HttpServerConfig;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.util.resource.PathResourceFactory;

public class HashLoginServiceProvider
implements Provider<HashLoginService> {
    private final HttpServerConfig config;

    @Inject
    public HashLoginServiceProvider(HttpServerConfig config) {
        this.config = config;
    }

    public HashLoginService get() {
        String authConfig = this.config.getUserAuthFile();
        if (!Strings.isNullOrEmpty((String)authConfig)) {
            return new HashLoginService("Airlift", new PathResourceFactory().newResource(authConfig));
        }
        return null;
    }
}

