/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.httpquery;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.http.server.HttpServerInfo;
import io.trino.cache.SafeCaches;
import io.trino.plugin.httpquery.HttpServerEventListenerConfig;
import io.trino.spi.eventlistener.EventListener;
import io.trino.spi.eventlistener.QueryCompletedEvent;
import io.trino.spi.eventlistener.QueryCreatedEvent;
import io.trino.spi.eventlistener.SplitCompletedEvent;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@Path(value="/v1/events")
public class HttpServerEventListener
implements EventListener {
    private final LifeCycleManager lifecycleManager;
    private final int serverPort;
    private Cache<String, QueryCompletedEvent> events;

    @Inject
    public HttpServerEventListener(HttpServerInfo httpServerInfo, LifeCycleManager lifecycleManager, HttpServerEventListenerConfig config) {
        this.serverPort = httpServerInfo.getHttpUri().getPort();
        this.lifecycleManager = Objects.requireNonNull(lifecycleManager, "lifecycleManager is null");
        Objects.requireNonNull(config, "http event listener config is null");
        this.events = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().maximumSize((long)config.getEventBufferSize()).expireAfterWrite(config.getEventTTL().toMillis(), TimeUnit.MILLISECONDS));
    }

    @GET
    @Path(value="completedQueries/get/{queryId}")
    @Produces(value={"application/json"})
    public QueryCompletedEvent get(@PathParam(value="queryId") String queryId) {
        QueryCompletedEvent event = (QueryCompletedEvent)this.events.getIfPresent((Object)queryId);
        if (event == null) {
            throw new NotFoundException("completion event for '" + queryId + "' not found");
        }
        return event;
    }

    @GET
    @Path(value="completedQueries/list")
    @Produces(value={"application/json"})
    public List<String> get(@Context UriInfo uriInfo) {
        return ImmutableList.copyOf(this.events.asMap().keySet());
    }

    public void queryCreated(QueryCreatedEvent queryCreatedEvent) {
    }

    public void queryCompleted(QueryCompletedEvent queryCompletedEvent) {
        this.events.put((Object)queryCompletedEvent.getMetadata().getQueryId(), (Object)queryCompletedEvent);
    }

    public void splitCompleted(SplitCompletedEvent splitCompletedEvent) {
    }

    @VisibleForTesting
    int getServerPort() {
        return this.serverPort;
    }

    public void shutdown() {
        this.lifecycleManager.stop();
    }
}

