/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.httpquery;

import com.google.common.collect.ImmutableMap;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.JsonResponseHandler;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.UnexpectedResponseException;
import io.airlift.http.client.jetty.JettyHttpClient;
import io.airlift.json.JsonCodec;
import io.trino.operator.RetryPolicy;
import io.trino.plugin.httpquery.HttpServerEventListener;
import io.trino.plugin.httpquery.HttpServerEventListenerFactory;
import io.trino.spi.eventlistener.QueryCompletedEvent;
import io.trino.spi.eventlistener.QueryContext;
import io.trino.spi.eventlistener.QueryIOMetadata;
import io.trino.spi.eventlistener.QueryMetadata;
import io.trino.spi.eventlistener.QueryStatistics;
import io.trino.spi.eventlistener.StageOutputBufferUtilization;
import io.trino.spi.resourcegroups.QueryType;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.session.ResourceEstimates;
import io.trino.spi.type.TimeZoneKey;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
final class TestHttpServerEventListener {
    private final HttpServerEventListenerFactory factory = new HttpServerEventListenerFactory();
    HttpClient httpClient = new JettyHttpClient();
    private static final JsonCodec<QueryCompletedEvent> queryCompleteEventJsonCodec = JsonCodec.jsonCodec(QueryCompletedEvent.class);
    private static final QueryCompletedEvent queryCompleteEvent;
    private static final QueryCompletedEvent queryCompleteEvent2;
    private static final String queryCompleteEventJson;
    private static final String queryCompleteEventJson2;

    TestHttpServerEventListener() {
    }

    @AfterAll
    void cleanUp() {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testHttpServerEventListener() {
        HttpServerEventListener eventListener = null;
        try {
            eventListener = this.createEventListener();
            int serverPort = eventListener.getServerPort();
            List events = (List)this.httpClient.execute(Request.Builder.prepareGet().setUri(TestHttpServerEventListener.getQueryCompletedListUri(serverPort)).build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.listJsonCodec(String.class)));
            Assertions.assertThat((List)events).isEmpty();
            eventListener.queryCompleted(queryCompleteEvent);
            events = (List)this.httpClient.execute(Request.Builder.prepareGet().setUri(TestHttpServerEventListener.getQueryCompletedListUri(serverPort)).build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.listJsonCodec(String.class)));
            Assertions.assertThat((List)events).containsExactlyInAnyOrder((Object[])new String[]{"queryId"});
            QueryCompletedEvent receivedEvent = (QueryCompletedEvent)this.httpClient.execute(Request.Builder.prepareGet().setUri(TestHttpServerEventListener.getQueryCompletedGetUri(serverPort, queryCompleteEvent.getMetadata().getQueryId())).build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(queryCompleteEventJsonCodec));
            Assertions.assertThat((String)queryCompleteEventJsonCodec.toJson((Object)receivedEvent)).isEqualTo(queryCompleteEventJson);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.httpClient.execute(Request.Builder.prepareGet().setUri(TestHttpServerEventListener.getQueryCompletedGetUri(serverPort, queryCompleteEvent2.getMetadata().getQueryId())).build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(queryCompleteEventJsonCodec))).isInstanceOf(UnexpectedResponseException.class)).matches(e -> ((UnexpectedResponseException)e).getStatusCode() == 404);
            eventListener.queryCompleted(queryCompleteEvent2);
            events = (List)this.httpClient.execute(Request.Builder.prepareGet().setUri(TestHttpServerEventListener.getQueryCompletedListUri(serverPort)).build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.listJsonCodec(String.class)));
            Assertions.assertThat((List)events).containsExactlyInAnyOrder((Object[])new String[]{"queryId", "queryId2"});
            receivedEvent = (QueryCompletedEvent)this.httpClient.execute(Request.Builder.prepareGet().setUri(TestHttpServerEventListener.getQueryCompletedGetUri(serverPort, queryCompleteEvent2.getMetadata().getQueryId())).build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(queryCompleteEventJsonCodec));
            Assertions.assertThat((String)queryCompleteEventJsonCodec.toJson((Object)receivedEvent)).isEqualTo(queryCompleteEventJson2);
        }
        finally {
            if (eventListener != null) {
                eventListener.shutdown();
            }
        }
    }

    private static URI getQueryCompletedListUri(int serverPort) {
        return URI.create(String.format("http://localhost:%s/v1/events/completedQueries/list", serverPort));
    }

    private static URI getQueryCompletedGetUri(int serverPort, String queryId) {
        return URI.create(String.format("http://localhost:%s/v1/events/completedQueries/get/%s", serverPort, queryId));
    }

    private HttpServerEventListener createEventListener() {
        return this.factory.createInternal((Map)ImmutableMap.builder().put((Object)"bootstrap.quiet", (Object)"true").buildOrThrow(), true);
    }

    static {
        QueryIOMetadata queryIOMetadata = new QueryIOMetadata(Collections.emptyList(), Optional.empty());
        QueryContext queryContext = new QueryContext("user", "originalUser", Optional.of("principal"), Set.of(), Set.of(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), new HashSet(), new HashSet(), Optional.of("source"), TimeZoneKey.UTC_KEY.getId(), Optional.of("catalog"), Optional.of("schema"), Optional.of(new ResourceGroupId("name")), new HashMap(), new ResourceEstimates(Optional.empty(), Optional.empty(), Optional.of(1000L)), "serverAddress", "serverVersion", "environment", Optional.of(QueryType.SELECT), RetryPolicy.QUERY.toString());
        QueryMetadata queryMetadata = new QueryMetadata("queryId", Optional.empty(), "query", Optional.of("updateType"), Optional.of("preparedQuery"), "queryState", List.of(), List.of(), URI.create("http://localhost"), Optional.empty(), Optional.empty(), Optional.empty());
        QueryMetadata queryMetadata2 = new QueryMetadata("queryId2", Optional.empty(), "query", Optional.of("updateType"), Optional.of("preparedQuery"), "queryState", List.of(), List.of(), URI.create("http://localhost"), Optional.empty(), Optional.empty(), Optional.empty());
        QueryStatistics queryStatistics = new QueryStatistics(Duration.ofSeconds(1L), Duration.ofSeconds(1L), Duration.ofSeconds(1L), Duration.ofSeconds(1L), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0.0, 0.0, Collections.emptyList(), 0, true, Collections.emptyList(), List.of(new StageOutputBufferUtilization(0, 10, 0.1, 0.5, 0.1, 0.25, 0.5, 0.75, 0.9, 0.95, 0.99, 0.0, 1.0, Duration.ofSeconds(1234L))), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Optional.empty());
        queryCompleteEvent = new QueryCompletedEvent(queryMetadata, queryStatistics, queryContext, queryIOMetadata, Optional.empty(), Collections.emptyList(), Instant.now(), Instant.now(), Instant.now());
        queryCompleteEvent2 = new QueryCompletedEvent(queryMetadata2, queryStatistics, queryContext, queryIOMetadata, Optional.empty(), Collections.emptyList(), Instant.now(), Instant.now(), Instant.now());
        queryCompleteEventJson = queryCompleteEventJsonCodec.toJson((Object)queryCompleteEvent);
        queryCompleteEventJson2 = queryCompleteEventJsonCodec.toJson((Object)queryCompleteEvent2);
    }
}

