/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cache;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.Weigher;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import io.trino.cache.EmptyCache;
import io.trino.cache.EvictableCache;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;

public final class EvictableCacheBuilder<K, V> {
    private Optional<Ticker> ticker = Optional.empty();
    private Optional<Duration> expireAfterWrite = Optional.empty();
    private Optional<Duration> refreshAfterWrite = Optional.empty();
    private Optional<Long> maximumSize = Optional.empty();
    private Optional<Long> maximumWeight = Optional.empty();
    private Optional<Integer> concurrencyLevel = Optional.empty();
    private Optional<Weigher<? super EvictableCache.Token<K>, ? super V>> weigher = Optional.empty();
    private boolean recordStats;
    private Optional<DisabledCacheImplementation> disabledCacheImplementation = Optional.empty();

    @CheckReturnValue
    public static EvictableCacheBuilder<Object, Object> newBuilder() {
        return new EvictableCacheBuilder<Object, Object>();
    }

    private EvictableCacheBuilder() {
    }

    @CanIgnoreReturnValue
    public EvictableCacheBuilder<K, V> ticker(Ticker ticker) {
        this.ticker = Optional.of(ticker);
        return this;
    }

    @CanIgnoreReturnValue
    public EvictableCacheBuilder<K, V> expireAfterWrite(long duration, TimeUnit unit) {
        return this.expireAfterWrite(EvictableCacheBuilder.toDuration(duration, unit));
    }

    @CanIgnoreReturnValue
    public EvictableCacheBuilder<K, V> expireAfterWrite(Duration duration) {
        Preconditions.checkState((boolean)this.expireAfterWrite.isEmpty(), (Object)"expireAfterWrite already set");
        this.expireAfterWrite = Optional.of(duration);
        return this;
    }

    @CanIgnoreReturnValue
    public EvictableCacheBuilder<K, V> refreshAfterWrite(long duration, TimeUnit unit) {
        return this.refreshAfterWrite(EvictableCacheBuilder.toDuration(duration, unit));
    }

    @CanIgnoreReturnValue
    public EvictableCacheBuilder<K, V> refreshAfterWrite(Duration duration) {
        Preconditions.checkState((boolean)this.refreshAfterWrite.isEmpty(), (Object)"refreshAfterWrite already set");
        this.refreshAfterWrite = Optional.of(duration);
        return this;
    }

    @CanIgnoreReturnValue
    public EvictableCacheBuilder<K, V> maximumSize(long maximumSize) {
        Preconditions.checkState((boolean)this.maximumSize.isEmpty(), (Object)"maximumSize already set");
        Preconditions.checkState((boolean)this.maximumWeight.isEmpty(), (Object)"maximumWeight already set");
        this.maximumSize = Optional.of(maximumSize);
        return this;
    }

    @CanIgnoreReturnValue
    public EvictableCacheBuilder<K, V> maximumWeight(long maximumWeight) {
        Preconditions.checkState((boolean)this.maximumWeight.isEmpty(), (Object)"maximumWeight already set");
        Preconditions.checkState((boolean)this.maximumSize.isEmpty(), (Object)"maximumSize already set");
        this.maximumWeight = Optional.of(maximumWeight);
        return this;
    }

    @CanIgnoreReturnValue
    public EvictableCacheBuilder<K, V> concurrencyLevel(int concurrencyLevel) {
        Preconditions.checkState((boolean)this.concurrencyLevel.isEmpty(), (Object)"concurrencyLevel already set");
        this.concurrencyLevel = Optional.of(concurrencyLevel);
        return this;
    }

    public <K1 extends K, V1 extends V> EvictableCacheBuilder<K1, V1> weigher(Weigher<? super K1, ? super V1> weigher) {
        Preconditions.checkState((boolean)this.weigher.isEmpty(), (Object)"weigher already set");
        EvictableCacheBuilder cast = this;
        cast.weigher = Optional.of(new TokenWeigher<K1, V1>(weigher));
        return cast;
    }

    @CanIgnoreReturnValue
    public EvictableCacheBuilder<K, V> recordStats() {
        this.recordStats = true;
        return this;
    }

    @CanIgnoreReturnValue
    public EvictableCacheBuilder<K, V> shareResultsAndFailuresEvenIfDisabled() {
        return this.disabledCacheImplementation(DisabledCacheImplementation.GUAVA);
    }

    @CanIgnoreReturnValue
    public EvictableCacheBuilder<K, V> shareNothingWhenDisabled() {
        return this.disabledCacheImplementation(DisabledCacheImplementation.NOOP);
    }

    @VisibleForTesting
    EvictableCacheBuilder<K, V> disabledCacheImplementation(DisabledCacheImplementation cacheImplementation) {
        Preconditions.checkState((boolean)this.disabledCacheImplementation.isEmpty(), (Object)"disabledCacheImplementation already set");
        this.disabledCacheImplementation = Optional.of(cacheImplementation);
        return this;
    }

    @CheckReturnValue
    public <K1 extends K, V1 extends V> Cache<K1, V1> build() {
        return this.build(EvictableCacheBuilder.unimplementedCacheLoader());
    }

    @CheckReturnValue
    public <K1 extends K, V1 extends V> LoadingCache<K1, V1> build(CacheLoader<? super K1, V1> loader) {
        if (this.cacheDisabled()) {
            DisabledCacheImplementation disabledCacheImplementation = this.disabledCacheImplementation.orElseThrow(() -> new IllegalStateException("Even when cache is disabled, the loads are synchronized and both load results and failures are shared between threads. This is rarely desired, thus builder caller is expected to either opt-in into this behavior with shareResultsAndFailuresEvenIfDisabled(), or choose not to share results (and failures) between concurrent invocations with shareNothingWhenDisabled()."));
            return switch (disabledCacheImplementation.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> new EmptyCache<K1, V1>(loader, this.recordStats);
                case 1 -> {
                    CacheBuilder cacheBuilder = CacheBuilder.newBuilder().maximumSize(0L).expireAfterWrite(0L, TimeUnit.SECONDS);
                    if (this.recordStats) {
                        cacheBuilder.recordStats();
                    }
                    yield EvictableCacheBuilder.buildUnsafeCache(cacheBuilder, loader);
                }
            };
        }
        if (!(this.maximumSize.isPresent() || this.maximumWeight.isPresent() || this.expireAfterWrite.isPresent())) {
            throw new IllegalStateException("Unbounded cache is not supported");
        }
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        this.ticker.ifPresent(arg_0 -> ((CacheBuilder)cacheBuilder).ticker(arg_0));
        this.expireAfterWrite.ifPresent(arg_0 -> ((CacheBuilder)cacheBuilder).expireAfterWrite(arg_0));
        this.refreshAfterWrite.ifPresent(arg_0 -> ((CacheBuilder)cacheBuilder).refreshAfterWrite(arg_0));
        this.maximumSize.ifPresent(arg_0 -> ((CacheBuilder)cacheBuilder).maximumSize(arg_0));
        this.maximumWeight.ifPresent(arg_0 -> ((CacheBuilder)cacheBuilder).maximumWeight(arg_0));
        this.weigher.ifPresent(arg_0 -> ((CacheBuilder)cacheBuilder).weigher(arg_0));
        this.concurrencyLevel.ifPresent(arg_0 -> ((CacheBuilder)cacheBuilder).concurrencyLevel(arg_0));
        if (this.recordStats) {
            cacheBuilder.recordStats();
        }
        return new EvictableCache<K1, V1>(cacheBuilder, loader);
    }

    private boolean cacheDisabled() {
        return this.maximumSize.isPresent() && this.maximumSize.get() == 0L || this.expireAfterWrite.isPresent() && this.expireAfterWrite.get().isZero();
    }

    @SuppressModernizer
    private static <K, V> LoadingCache<K, V> buildUnsafeCache(CacheBuilder<? super K, ? super V> cacheBuilder, CacheLoader<? super K, V> cacheLoader) {
        return cacheBuilder.build(cacheLoader);
    }

    private static <K, V> CacheLoader<K, V> unimplementedCacheLoader() {
        return CacheLoader.from(object -> {
            throw new UnsupportedOperationException();
        });
    }

    private static Duration toDuration(long duration, TimeUnit unit) {
        return Duration.ofNanos(unit.toNanos(duration));
    }

    private record TokenWeigher<K, V>(Weigher<? super K, ? super V> delegate) implements Weigher<EvictableCache.Token<K>, V>
    {
        private TokenWeigher {
            Objects.requireNonNull(delegate, "delegate is null");
        }

        public int weigh(EvictableCache.Token<K> key, V value) {
            return this.delegate.weigh(key.getKey(), value);
        }
    }

    @VisibleForTesting
    static enum DisabledCacheImplementation {
        NOOP,
        GUAVA;

    }
}

