/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server.testing;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.airlift.event.client.EventClient;
import io.airlift.event.client.NullEventClient;
import io.airlift.http.server.EnableCaseSensitiveHeaderCache;
import io.airlift.http.server.EnableLegacyUriCompliance;
import io.airlift.http.server.EnableVirtualThreads;
import io.airlift.http.server.HttpServer;
import io.airlift.http.server.HttpServerBinder;
import io.airlift.http.server.HttpServerConfig;
import io.airlift.http.server.HttpServerInfo;
import io.airlift.http.server.HttpsConfig;
import io.airlift.http.server.RequestStats;
import io.airlift.http.server.TheServlet;
import io.airlift.node.NodeInfo;
import io.airlift.tracetoken.TraceTokenManager;
import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class TestingHttpServer
extends HttpServer {
    private final HttpServerInfo httpServerInfo;

    public TestingHttpServer(HttpServerInfo httpServerInfo, NodeInfo nodeInfo, HttpServerConfig config, @TheServlet Servlet servlet, @TheServlet Map<String, String> initParameters) throws IOException {
        this(httpServerInfo, nodeInfo, config, servlet, initParameters, false, false, false);
    }

    public TestingHttpServer(HttpServerInfo httpServerInfo, NodeInfo nodeInfo, HttpServerConfig config, @TheServlet Servlet servlet, @TheServlet Map<String, String> initParameters, boolean enableVirtualThreads, boolean enableLegacyUriCompliance, boolean enableCaseSensitiveHeaderCache) throws IOException {
        this(httpServerInfo, nodeInfo, config, Optional.empty(), servlet, initParameters, (Set<Filter>)ImmutableSet.of(), (Set<HttpServerBinder.HttpResourceBinding>)ImmutableSet.of(), enableVirtualThreads, enableLegacyUriCompliance, enableCaseSensitiveHeaderCache, HttpServer.ClientCertificate.NONE);
    }

    @Inject
    public TestingHttpServer(HttpServerInfo httpServerInfo, NodeInfo nodeInfo, HttpServerConfig config, Optional<HttpsConfig> httpsConfig, @TheServlet Servlet servlet, @TheServlet Map<String, String> initParameters, @TheServlet Set<Filter> filters, @TheServlet Set<HttpServerBinder.HttpResourceBinding> resources, @EnableVirtualThreads boolean enableVirtualThreads, @EnableLegacyUriCompliance boolean enableLegacyUriCompliance, @EnableCaseSensitiveHeaderCache boolean enableCaseSensitiveHeaderCache, HttpServer.ClientCertificate clientCertificate) throws IOException {
        super(httpServerInfo, nodeInfo, config.setLogEnabled(false), httpsConfig, servlet, initParameters, (Set<Filter>)ImmutableSet.copyOf(filters), (Set<HttpServerBinder.HttpResourceBinding>)ImmutableSet.copyOf(resources), null, null, (Set<Filter>)ImmutableSet.of(), enableVirtualThreads, enableLegacyUriCompliance, enableCaseSensitiveHeaderCache, clientCertificate, null, null, new TraceTokenManager(), new RequestStats(), (EventClient)new NullEventClient(), Optional.empty());
        this.httpServerInfo = httpServerInfo;
    }

    public URI getBaseUrl() {
        return this.httpServerInfo.getHttpUri();
    }

    public int getPort() {
        return this.httpServerInfo.getHttpUri().getPort();
    }

    public HttpServerInfo getHttpServerInfo() {
        return this.httpServerInfo;
    }
}

