/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.classloader;

import io.trino.plugin.base.classloader.ClassLoaderSafeTableFunctionProcessorProvider;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.function.table.TableFunctionProcessorProvider;
import io.trino.spi.function.table.TableFunctionProcessorProviderFactory;
import java.util.Objects;

public final class ClassLoaderSafeTableFunctionProcessorProviderFactory
implements TableFunctionProcessorProviderFactory {
    private final TableFunctionProcessorProviderFactory delegate;
    private final ClassLoader classLoader;

    public ClassLoaderSafeTableFunctionProcessorProviderFactory(TableFunctionProcessorProviderFactory delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    public TableFunctionProcessorProvider createTableFunctionProcessorProvider() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ClassLoaderSafeTableFunctionProcessorProvider classLoaderSafeTableFunctionProcessorProvider = new ClassLoaderSafeTableFunctionProcessorProvider(this.delegate.createTableFunctionProcessorProvider(), this.classLoader);
            return classLoaderSafeTableFunctionProcessorProvider;
        }
    }
}

