/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.classloader;

import io.trino.plugin.base.classloader.ForClassLoaderSafe;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.function.table.Argument;
import io.trino.spi.function.table.ArgumentSpecification;
import io.trino.spi.function.table.ConnectorTableFunction;
import io.trino.spi.function.table.ReturnTypeSpecification;
import io.trino.spi.function.table.TableFunctionAnalysis;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ClassLoaderSafeConnectorTableFunction
implements ConnectorTableFunction {
    private final ConnectorTableFunction delegate;
    private final ClassLoader classLoader;

    public ClassLoaderSafeConnectorTableFunction(@ForClassLoaderSafe ConnectorTableFunction delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    public String getSchema() {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            String string = this.delegate.getSchema();
            return string;
        }
    }

    public String getName() {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            String string = this.delegate.getName();
            return string;
        }
    }

    public List<ArgumentSpecification> getArguments() {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            List list = this.delegate.getArguments();
            return list;
        }
    }

    public ReturnTypeSpecification getReturnTypeSpecification() {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            ReturnTypeSpecification returnTypeSpecification = this.delegate.getReturnTypeSpecification();
            return returnTypeSpecification;
        }
    }

    public TableFunctionAnalysis analyze(ConnectorSession session, ConnectorTransactionHandle transaction, Map<String, Argument> arguments, ConnectorAccessControl accessControl) {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            TableFunctionAnalysis tableFunctionAnalysis = this.delegate.analyze(session, transaction, arguments, accessControl);
            return tableFunctionAnalysis;
        }
    }
}

