/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.log;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import io.airlift.log.Level;
import io.airlift.log.TerminalColors;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

class StaticFormatter
extends Formatter {
    private static final ZoneId SYSTEM_ZONE = ZoneId.systemDefault().normalized();
    private final Map<String, String> logAnnotations;
    private final TerminalColors colors;
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendLiteral('.').appendValue(ChronoField.MILLI_OF_SECOND, 3).appendOffset("+HHMM", "Z").toFormatter(Locale.US);

    public StaticFormatter() {
        this((Map<String, String>)ImmutableMap.of(), false);
    }

    public StaticFormatter(Map<String, String> logAnnotations, boolean interactive) {
        this.logAnnotations = ImmutableMap.copyOf(Objects.requireNonNull(logAnnotations, "logAnnotations is null"));
        this.colors = new TerminalColors(interactive);
    }

    @Override
    public String formatMessage(LogRecord record) {
        return this.format(record);
    }

    @Override
    public String format(LogRecord record) {
        ZonedDateTime timestamp = ZonedDateTime.ofInstant(Instant.ofEpochMilli(record.getMillis()), SYSTEM_ZONE);
        Level level = Level.fromJulLevel(record.getLevel());
        StringWriter stringWriter = new StringWriter().append(this.colors.colored(TIMESTAMP_FORMATTER.format(timestamp), TerminalColors.Color.BRIGHT_BLACK)).append('\t').append(this.colors.colored(level.name(), level)).append('\t').append(this.colors.colored(Thread.currentThread().getName(), TerminalColors.Color.CYAN)).append('\t').append(this.colors.colored(record.getLoggerName(), TerminalColors.Color.PURPLE));
        if (!this.logAnnotations.isEmpty()) {
            stringWriter.append('\t').append(this.colors.colored(Joiner.on((String)",").withKeyValueSeparator("=").join(this.logAnnotations), level));
        }
        stringWriter.append('\t').append(this.colors.colored(record.getMessage(), TerminalColors.Color.WHITE));
        if (record.getParameters() != null && record.getParameters().length != 0) {
            stringWriter.append(" parameters=").append(Arrays.deepToString(record.getParameters()));
        }
        if (record.getThrown() != null) {
            stringWriter.append('\n');
            record.getThrown().printStackTrace(TerminalColors.coloredWriter(new PrintWriter(stringWriter), TerminalColors.Color.GREEN));
            stringWriter.append('\n');
        }
        stringWriter.append('\n');
        return stringWriter.toString();
    }
}

