/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.classloader;

import com.google.inject.Inject;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorMergeSink;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorPageSink;
import io.trino.plugin.base.classloader.ForClassLoaderSafe;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorMergeSink;
import io.trino.spi.connector.ConnectorMergeTableHandle;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorPageSinkId;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableExecuteHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import java.util.Objects;

public final class ClassLoaderSafeConnectorPageSinkProvider
implements ConnectorPageSinkProvider {
    private final ConnectorPageSinkProvider delegate;
    private final ClassLoader classLoader;

    @Inject
    public ClassLoaderSafeConnectorPageSinkProvider(@ForClassLoaderSafe ConnectorPageSinkProvider delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorOutputTableHandle outputTableHandle, ConnectorPageSinkId pageSinkId) {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            ClassLoaderSafeConnectorPageSink classLoaderSafeConnectorPageSink = new ClassLoaderSafeConnectorPageSink(this.delegate.createPageSink(transactionHandle, session, outputTableHandle, pageSinkId), this.classLoader);
            return classLoaderSafeConnectorPageSink;
        }
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorInsertTableHandle insertTableHandle, ConnectorPageSinkId pageSinkId) {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            ClassLoaderSafeConnectorPageSink classLoaderSafeConnectorPageSink = new ClassLoaderSafeConnectorPageSink(this.delegate.createPageSink(transactionHandle, session, insertTableHandle, pageSinkId), this.classLoader);
            return classLoaderSafeConnectorPageSink;
        }
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorTableExecuteHandle tableExecuteHandle, ConnectorPageSinkId pageSinkId) {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            ClassLoaderSafeConnectorPageSink classLoaderSafeConnectorPageSink = new ClassLoaderSafeConnectorPageSink(this.delegate.createPageSink(transactionHandle, session, tableExecuteHandle, pageSinkId), this.classLoader);
            return classLoaderSafeConnectorPageSink;
        }
    }

    public ConnectorMergeSink createMergeSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorMergeTableHandle mergeHandle, ConnectorPageSinkId pageSinkId) {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            ClassLoaderSafeConnectorMergeSink classLoaderSafeConnectorMergeSink = new ClassLoaderSafeConnectorMergeSink(this.delegate.createMergeSink(transactionHandle, session, mergeHandle, pageSinkId), this.classLoader);
            return classLoaderSafeConnectorMergeSink;
        }
    }
}

