/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client.jetty;

import io.airlift.http.client.jetty.JettyResponseFuture;
import java.util.Objects;
import org.eclipse.jetty.client.BufferingResponseListener;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.client.Response;
import org.eclipse.jetty.client.Result;

class JettyResponseListener<T, E extends Exception>
extends BufferingResponseListener {
    private final Request request;
    private final JettyResponseFuture<T, E> future;

    public JettyResponseListener(Request request, JettyResponseFuture<T, E> future, int maxLength) {
        super(maxLength);
        this.future = Objects.requireNonNull(future, "future is null");
        this.request = Objects.requireNonNull(request, "request is null");
    }

    public JettyResponseFuture<T, E> send() {
        this.request.send((Response.CompleteListener)this);
        return this.future;
    }

    public void onComplete(Result result) {
        if (result.isFailed()) {
            this.future.failed(result.getFailure());
        } else {
            this.future.completed(result.getResponse(), this.getContentAsInputStream());
        }
    }
}

