/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.client.transport.internal;

import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.HTTP2Channel;
import org.eclipse.jetty.http2.HTTP2Stream;
import org.eclipse.jetty.http2.HTTP2StreamEndPoint;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientHTTP2StreamEndPoint
extends HTTP2StreamEndPoint
implements HTTP2Channel.Client {
    private static final Logger LOG = LoggerFactory.getLogger(ClientHTTP2StreamEndPoint.class);

    public ClientHTTP2StreamEndPoint(HTTP2Stream stream) {
        super(stream);
    }

    public Runnable onDataAvailable() {
        return new Invocable.ReadyTask(this.getInvocationType(), () -> this.processDataAvailable());
    }

    public Runnable onReset(ResetFrame frame, Callback callback) {
        int error = frame.getError();
        EofException failure = new EofException(ErrorCode.toString((int)error, (String)("error_code_" + error)));
        return this.onFailure((Throwable)failure, callback);
    }

    public Runnable onTimeout(TimeoutException timeout, Promise<Boolean> promise) {
        Connection connection;
        if (LOG.isDebugEnabled()) {
            LOG.debug("idle timeout on {}", (Object)this, (Object)timeout);
        }
        if ((connection = this.getConnection()) == null) {
            promise.succeeded((Object)true);
            return null;
        }
        return new Invocable.ReadyTask(Invocable.InvocationType.NON_BLOCKING, () -> {
            boolean expire = connection.onIdleExpired(timeout);
            if (expire) {
                this.processFailure(timeout);
                this.close(timeout);
            }
            promise.succeeded((Object)expire);
        });
    }

    public Runnable onFailure(Throwable failure, Callback callback) {
        return new Invocable.ReadyTask(Invocable.InvocationType.NON_BLOCKING, () -> {
            this.processFailure(failure);
            this.close(failure);
            callback.failed(failure);
        });
    }
}

