/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.functions.python;

import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.plugin.functions.python.PythonFunctionsPlugin;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Plugin;
import io.trino.spi.StandardErrorCode;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.StandaloneQueryRunner;
import io.trino.testing.TestingSession;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.util.Map;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestPythonFunctions {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        Session session = TestingSession.testSessionBuilder().setCatalog("test_catalog").setSchema("tiny").build();
        StandaloneQueryRunner runner = new StandaloneQueryRunner(session);
        runner.installPlugin((Plugin)new TpchPlugin());
        runner.createCatalog("test_catalog", "tpch", (Map)ImmutableMap.of((Object)"tpch.splits-per-node", (Object)"1"));
        runner.installPlugin((Plugin)new PythonFunctionsPlugin());
        this.assertions = new QueryAssertions((QueryRunner)runner);
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testInlineFunctions() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION my_func(x bigint)\nRETURNS bigint\nLANGUAGE PYTHON\nWITH (handler = 'twice')\nAS $$\ndef twice(x):\n    return x * 2\n$$\nSELECT my_func(nationkey)\nFROM nation\nWHERE nationkey = 21\n"))).matches("VALUES bigint '42'");
    }

    @Test
    public void testStripIndent() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION my_func(x bigint)\n    RETURNS bigint\n    LANGUAGE PYTHON\n    WITH (handler = 'twice')\n    AS $$\n    def twice(x):\n        return x * 2\n    $$\nSELECT my_func(nationkey)\nFROM nation\nWHERE nationkey = 21\n"))).matches("VALUES bigint '42'");
    }

    @Test
    public void testInvalidHandler() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION my_func(x bigint)\nRETURNS bigint\nLANGUAGE PYTHON\nWITH (handler = 'bad')\nAS $$\ndef twice(x):\n    return x * 2\n$$\nSELECT my_func(13)\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR}).hasMessage("line 1:6: Invalid function 'my_func': Python error:\nAttributeError: module 'guest' has no attribute 'bad'\nCannot find function 'bad' in 'guest'\n".stripTrailing());
    }

    @Test
    public void testSyntaxError() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION my_func(x bigint)\nRETURNS bigint\nLANGUAGE PYTHON\nWITH (handler = 'twice')\nAS $$\ndefxxx twice(x):\n    return x * 2\n$$\nSELECT my_func(13)\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR}).hasMessage("line 1:6: Invalid function 'my_func': Python error:\nFile \"/guest/guest.py\", line 1\n    defxxx twice(x):\n           ^^^^^\nSyntaxError: invalid syntax\nFailed to load Python module 'guest'\n".stripTrailing());
    }

    @Test
    public void testDivideByZero() {
        ((TrinoExceptionAssert)((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION my_func(x bigint)\nRETURNS bigint\nLANGUAGE PYTHON\nWITH (handler = 'divzero')\nAS $$\ndef divzero(x):\n    return x / 0\n$$\nSELECT my_func(nationkey)\nFROM nation\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DIVISION_BY_ZERO}).hasMessage("division by zero")).hasRootCauseMessage("Python traceback:\nTraceback (most recent call last):\n  File \"/guest/guest.py\", line 2, in divzero\n    return x / 0\n           ~~^~~\nZeroDivisionError: division by zero\n".stripTrailing());
    }

    @Test
    public void testNotSupported() {
        ((TrinoExceptionAssert)((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION my_func(x bigint)\nRETURNS bigint\nLANGUAGE PYTHON\nWITH (handler = 'notsupported')\nAS $$\nfrom trino import *\ndef notsupported(x):\n    raise TrinoError(NOT_SUPPORTED, \"test not-supported\")\n$$\nSELECT my_func(nationkey)\nFROM nation\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("test not-supported")).hasRootCauseMessage("Python traceback:\nTraceback (most recent call last):\n  File \"/guest/guest.py\", line 3, in notsupported\n    raise TrinoError(NOT_SUPPORTED, \"test not-supported\")\ntrino.TrinoError: test not-supported\n".stripTrailing());
    }

    @Test
    public void testNumericValueOutOfRange() {
        ((TrinoExceptionAssert)((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION my_func(x bigint)\nRETURNS bigint\nLANGUAGE PYTHON\nWITH (handler = 'outofrange')\nAS $$\nfrom trino import *\ndef outofrange(x):\n    raise NumericValueOutOfRangeError(\"test out-of-range\")\n$$\nSELECT my_func(nationkey)\nFROM nation\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE}).hasMessage("test out-of-range")).hasRootCauseMessage("Python traceback:\nTraceback (most recent call last):\n  File \"/guest/guest.py\", line 3, in outofrange\n    raise NumericValueOutOfRangeError(\"test out-of-range\")\ntrino.NumericValueOutOfRangeError: test out-of-range\n".stripTrailing());
    }

    @Test
    public void testInvalidFunctionArgument() {
        ((TrinoExceptionAssert)((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION my_func(x bigint)\nRETURNS bigint\nLANGUAGE PYTHON\nWITH (handler = 'badArg')\nAS $$\nfrom trino import *\ndef badArg(x):\n    raise InvalidFunctionArgumentError(\"test bad-arg\")\n$$\nSELECT my_func(nationkey)\nFROM nation\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("test bad-arg")).hasRootCauseMessage("Python traceback:\nTraceback (most recent call last):\n  File \"/guest/guest.py\", line 3, in badArg\n    raise InvalidFunctionArgumentError(\"test bad-arg\")\ntrino.InvalidFunctionArgumentError: test bad-arg\n".stripTrailing());
    }

    @Test
    public void testGenericException() {
        ((TrinoExceptionAssert)((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION my_func(x bigint)\nRETURNS bigint\nLANGUAGE PYTHON\nWITH (handler = 'other')\nAS $$\nfrom trino import *\ndef other(x):\n    raise ValueError(\"test other\")\n$$\nSELECT my_func(nationkey)\nFROM nation\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR}).hasMessage("ValueError: test other")).hasRootCauseMessage("Python traceback:\nTraceback (most recent call last):\n  File \"/guest/guest.py\", line 3, in other\n    raise ValueError(\"test other\")\nValueError: test other\n".stripTrailing());
    }

    @Test
    public void testTooFewArguments() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION my_func(s varchar)\nRETURNS bigint\nLANGUAGE PYTHON\nWITH (handler = 'oops')\nAS $$\ndef oops(a, b):\n    return a + b\n$$\nSELECT my_func(comment)\nFROM nation\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR}).hasMessage("TypeError: oops() missing 1 required positional argument: 'b'");
    }

    @Test
    public void testNoArgument() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION the_answer()\nRETURNS integer\nLANGUAGE PYTHON\nWITH (handler = 'answer')\nAS $$\ndef answer():\n    return 42\n$$\nSELECT the_answer()\n"))).matches("VALUES 42");
    }

    @Test
    public void testMemoryLimitNoTraceback() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION huge(n bigint)\nRETURNS bigint\nLANGUAGE PYTHON\nWITH (handler = 'huge')\nAS $$\ndef huge(n):\n    x = []\n    for i in range(0, 40):\n        x.append(bytearray(1024 * 1024))\n$$\nSELECT huge(nationkey)\nFROM nation\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXCEEDED_FUNCTION_MEMORY_LIMIT}).hasMessage("Python MemoryError (no traceback available)");
    }

    @Test
    public void testMemoryLimitWithTraceback() {
        ((TrinoExceptionAssert)((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION huge(n bigint)\nRETURNS bigint\nLANGUAGE PYTHON\nWITH (handler = 'huge')\nAS $$\ndef huge(n):\n    x = []\n    for i in range(0, 40):\n        x.append(bytearray(1024 * 1024 * 3))\n$$\nSELECT huge(nationkey)\nFROM nation\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXCEEDED_FUNCTION_MEMORY_LIMIT}).hasMessage("Python MemoryError")).hasRootCauseMessage("Python traceback:\nTraceback (most recent call last):\n  File \"/guest/guest.py\", line 4, in huge\n    x.append(bytearray(1024 * 1024 * 3))\n             ~~~~~~~~~^^^^^^^^^^^^^^^^^\nMemoryError\n".stripTrailing());
    }

    @Test
    public void testFileSystemBadFileWrite() {
        ((TrinoExceptionAssert)((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION bad_write()\nRETURNS varchar\nLANGUAGE PYTHON\nWITH (handler = 'bad_write')\nAS $$\ndef bad_write():\n    with open('/test.txt', 'w') as f:\n        f.write('hello')\n$$\nSELECT bad_write()\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR}).hasMessage("FileNotFoundError: [Errno 44] No such file or directory: '/test.txt'")).hasRootCauseMessage("Python traceback:\nTraceback (most recent call last):\n  File \"/guest/guest.py\", line 2, in bad_write\n    with open('/test.txt', 'w') as f:\n         ~~~~^^^^^^^^^^^^^^^^^^\nFileNotFoundError: [Errno 44] No such file or directory: '/test.txt'\n".stripTrailing());
    }

    @Test
    public void testFileSystemOverwritePython() {
        ((TrinoExceptionAssert)((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION bad_write()\nRETURNS varchar\nLANGUAGE PYTHON\nWITH (handler = 'bad_write')\nAS $$\nimport os, sysconfig\nlibdir = sysconfig.get_path('purelib')\ndef bad_write():\n    name = os.path.join(libdir, 'trino.py')\n    assert os.path.exists(name)\n    with open(name, 'w') as f:\n        f.write('hello')\n$$\nSELECT bad_write()\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR}).hasMessage("OSError: [Errno 58] Not supported")).hasRootCauseMessage("Python traceback:\nOSError: [Errno 58] Not supported\n\nDuring handling of the above exception, another exception occurred:\n\nTraceback (most recent call last):\n  File \"/guest/guest.py\", line 6, in bad_write\n    with open(name, 'w') as f:\n         ~~~~^^^^^^^^^^^\nOSError: [Errno 58] Not supported\n".stripTrailing());
    }

    @Test
    public void testFileSystemSmallFileWrite() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION small_write()\nRETURNS varchar\nLANGUAGE PYTHON\nWITH (handler = 'small_write')\nAS $$\ndef small_write():\n    with open('/guest/test.txt', 'w') as f:\n        f.write('hello')\n    with open('/guest/test.txt', 'r') as f:\n        return f.read()\n$$\nSELECT small_write()\n"))).matches("SELECT varchar 'hello'");
    }

    @Test
    public void testFileSystemLargeFileWrite() {
        ((TrinoExceptionAssert)((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION large_write()\nRETURNS varchar\nLANGUAGE PYTHON\nWITH (handler = 'large_write')\nAS $$\ndef large_write():\n    file_size = 16 * 1024 * 1024\n    data = b'x' * 4096\n    with open('/guest/test.zero', 'wb') as f:\n        for _ in range(file_size // len(data)):\n            f.write(data)\n$$\nSELECT large_write()\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR}).hasMessage("OSError: [Errno 29] I/O error")).hasRootCauseMessage("Python traceback:\nTraceback (most recent call last):\n  File \"/guest/guest.py\", line 6, in large_write\n    f.write(data)\n    ~~~~~~~^^^^^^\nOSError: [Errno 29] I/O error\n\nDuring handling of the above exception, another exception occurred:\n\nTraceback (most recent call last):\n  File \"/guest/guest.py\", line 4, in large_write\n    with open('/guest/test.zero', 'wb') as f:\n         ~~~~^^^^^^^^^^^^^^^^^^^^^^^^^^\nOSError: [Errno 29] I/O error\n".stripTrailing());
    }

    @Test
    public void testSplitWords() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION reverse_words(s varchar)\nRETURNS varchar\nLANGUAGE PYTHON\nWITH (handler = 'reverse_words')\nAS $$\nimport re\n\ndef reverse(s):\n    str = \"\"\n    for i in s:\n        str = i + str\n    return str\n\npattern = re.compile(r\"\\w+[.,'!?\\\"]\\w*\")\n\ndef process_word(word):\n    # Reverse only words without non-letter signs\n    return word if pattern.match(word) else reverse(word)\n\ndef reverse_words(payload):\n    text_words = payload.split(' ')\n    return ' '.join([process_word(w) for w in text_words])\n$$\nSELECT comment, reverse_words(comment)\nFROM nation\nWHERE nationkey IN (5, 6, 12)\n"))).skippingTypesCheck().matches("VALUES\n    ('ven packages wake quickly. regu', 'nev segakcap ekaw quickly. uger'),\n    ('refully final requests. regular, ironi', 'yllufer lanif requests. regular, inori'),\n    ('ously. final, express gifts cajole a', 'ously. final, sserpxe stfig elojac a')\n");
    }

    @Test
    public void testAssert() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION test_assert()\nRETURNS varchar\nLANGUAGE PYTHON\nWITH (handler = 'test_assert')\nAS $$\ndef test_assert():\n    assert False, \"test fail\"\n$$\nSELECT test_assert()\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR}).hasMessage("AssertionError: test fail");
    }

    @Test
    public void testNulls() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION null_input(a varchar, b bigint)\nRETURNS boolean\nLANGUAGE PYTHON\nWITH (handler = 'null_input')\nAS $$\ndef null_input(a, b):\n    assert a is None\n    assert b is None\n    return True\n$$\nSELECT null_input(null, null)\n"))).matches("VALUES true");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION null_output()\nRETURNS boolean\nLANGUAGE PYTHON\nWITH (handler = 'null_output')\nAS $$\ndef null_output():\n    return None\n$$\nSELECT null_output()\n"))).matches("VALUES cast(null AS boolean)");
    }

    @Test
    public void testUnupportedArgumentType() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION invalid(x HyperLogLog)\nRETURNS bigint\nLANGUAGE PYTHON\nWITH (handler = 'invalid')\nAS $$\ndef invalid():\n    return None\n$$\nSELECT invalid()\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:6: Invalid function 'invalid': Unsupported type: HyperLogLog");
    }

    @Test
    public void testUnsupportedReturnType() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION invalid()\nRETURNS HyperLogLog\nLANGUAGE PYTHON\nWITH (handler = 'invalid')\nAS $$\ndef invalid():\n    return None\n$$\nSELECT invalid()\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:6: Invalid function 'invalid': Unsupported type: HyperLogLog");
    }

    @Test
    public void testTypeBoolean() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION xor(a boolean, b boolean)\nRETURNS boolean\nLANGUAGE PYTHON\nWITH (handler = 'xor')\nAS $$\nimport operator\ndef xor(a, b):\n    return operator.xor(a, b)\n$$\nSELECT xor(false, false), xor(false, true), xor(true, false), xor(true, true)\n"))).matches("VALUES (false, true, true, false)");
    }

    @Test
    public void testTypeBigint() {
        String query = "WITH FUNCTION multiply(x bigint, y bigint)\nRETURNS bigint\nLANGUAGE PYTHON\nWITH (handler = 'multiply')\nAS $$\ndef multiply(x, y):\n    return x * y\n$$\n";
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query(query + "SELECT multiply(12345678, 87654321)"))).matches("VALUES 1082152022374638");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query(query + "SELECT multiply(12345678901, 10987654321)"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE}).hasMessage("Value out of range for BIGINT");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION bad_bigint_return()\nRETURNS bigint\nLANGUAGE PYTHON\nWITH (handler = 'invalid')\nAS $$\ndef invalid():\n    return 'hello'\n$$\nSELECT bad_bigint_return()\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR}).hasMessage("Failed to convert Python result type 'str' to Trino type BIGINT: TypeError: 'str' object cannot be interpreted as an integer");
    }

    @Test
    public void testTypeInteger() {
        String query = "WITH FUNCTION multiply(x integer, y integer)\nRETURNS integer\nLANGUAGE PYTHON\nWITH (handler = 'multiply')\nAS $$\ndef multiply(x, y):\n    return x * y\n$$\n";
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query(query + "SELECT multiply(12345, 54321)"))).matches("VALUES 670592745");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query(query + "SELECT multiply(12345678, 87654321)"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE}).hasMessage("Value out of range for INTEGER");
    }

    @Test
    public void testTypeSmallint() {
        String query = "WITH FUNCTION multiply(x smallint, y smallint)\nRETURNS smallint\nLANGUAGE PYTHON\nWITH (handler = 'multiply')\nAS $$\ndef multiply(x, y):\n    return x * y\n$$\n";
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query(query + "SELECT multiply(smallint '123', smallint '231')"))).matches("VALUES smallint '28413'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query(query + "SELECT multiply(smallint '12345', smallint '32145')"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE}).hasMessage("Value out of range for SMALLINT");
    }

    @Test
    public void testTypeTinyint() {
        String query = "WITH FUNCTION multiply(x tinyint, y tinyint)\nRETURNS tinyint\nLANGUAGE PYTHON\nWITH (handler = 'multiply')\nAS $$\ndef multiply(x, y):\n    return x * y\n$$\n";
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query(query + "SELECT multiply(tinyint '9', tinyint '13')"))).matches("VALUES tinyint '117'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query(query + "SELECT multiply(tinyint '123', tinyint '99')"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE}).hasMessage("Value out of range for TINYINT");
    }

    @Test
    public void testTypeDouble() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION multiply(x double, y double)\nRETURNS double\nLANGUAGE PYTHON\nWITH (handler = 'multiply')\nAS $$\ndef multiply(x, y):\n    return x * y\n$$\nSELECT multiply(123.45, 67.89)\n"))).matches("VALUES double '8381.0205'");
    }

    @Test
    public void testTypeReal() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION multiply(x real, y real)\nRETURNS real\nLANGUAGE PYTHON\nWITH (handler = 'multiply')\nAS $$\ndef multiply(x, y):\n    return x * y\n$$\nSELECT multiply(123.45, 67.89)\n"))).matches("VALUES real '8381.0205'");
    }

    @Test
    public void testTypeDecimal() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION test_decimal_short(x decimal(18, 5))\nRETURNS decimal(18, 5)\nLANGUAGE PYTHON\nWITH (handler = 'square')\nAS $$\ndef square(x):\n    assert str(x) == '123.45600'\n    return x * x\n$$\nSELECT test_decimal_short(123.456)\n"))).matches("VALUES cast(15241.38394 AS decimal(18, 5))");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION test_decimal_long(x decimal(38, 5))\nRETURNS decimal(38, 5)\nLANGUAGE PYTHON\nWITH (handler = 'test')\nAS $$\nfrom decimal import Decimal\ndef test(x):\n    assert str(x) == '12345678901234567890.12340'\n    return x * Decimal('123.456')\n$$\nSELECT test_decimal_long(12345678901234567890.1234)\n"))).matches("VALUES cast(1524148134430814813443.07447 AS decimal(38, 5))");
    }

    @Test
    public void testTypeVarchar() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION my_concat(x varchar(16), y varchar(16))\nRETURNS varchar\nLANGUAGE PYTHON\nWITH (handler = 'concat')\nAS $$\ndef concat(x, y):\n    return x + y\n$$\nSELECT my_concat(cast('hello' AS varchar(8)), cast('world' AS varchar(8)))\n"))).matches("VALUES cast('helloworld' AS varchar)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION bad_varchar_return()\nRETURNS varchar\nLANGUAGE PYTHON\nWITH (handler = 'invalid')\nAS $$\ndef invalid():\n    return 123\n$$\nSELECT bad_varchar_return()\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR}).hasMessage("Failed to convert Python result type 'int' to Trino type VARCHAR: TypeError: expected an instance of type 'str'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION my_concat(x varchar, y varchar)\nRETURNS varchar(32)\nLANGUAGE PYTHON\nWITH (handler = 'concat')\nAS $$\ndef concat(x, y):\n    return x + y\n$$\nSELECT my_concat('hello', 'world')\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:6: Invalid function 'my_concat': Type VARCHAR(x) not supported as return type. Use VARCHAR instead.");
    }

    @Test
    public void testTypeVarbinary() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION my_concat(x varbinary, y varbinary)\nRETURNS varbinary\nLANGUAGE PYTHON\nWITH (handler = 'concat')\nAS $$\ndef concat(x, y):\n    return bytearray(x + y)\n$$\nSELECT my_concat(varbinary 'abc', varbinary 'xyz')\n"))).matches("VALUES varbinary 'abcxyz'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION bad_varbinary_return()\nRETURNS varbinary\nLANGUAGE PYTHON\nWITH (handler = 'invalid')\nAS $$\ndef invalid():\n    return 'hello'\n$$\nSELECT bad_varbinary_return()\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR}).hasMessage("Failed to convert Python result type 'str' to Trino type VARBINARY: TypeError: a bytes-like object is required, not 'str'");
    }

    @Test
    public void testTypeDate() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION add_week(x date)\nRETURNS date\nLANGUAGE PYTHON\nWITH (handler = 'add_week')\nAS $$\nfrom datetime import datetime, timedelta\ndef add_week(x):\n    assert str(x) == '2024-06-27'\n    return x + timedelta(weeks=1)\n$$\nSELECT add_week(date '2024-06-27')\n"))).matches("VALUES date '2024-07-04'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION bad_date_return()\nRETURNS date\nLANGUAGE PYTHON\nWITH (handler = 'invalid')\nAS $$\ndef invalid():\n    return 123\n$$\nSELECT bad_date_return()\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR}).hasMessage("Failed to convert Python result type 'int' to Trino type DATE: TypeError: expected an instance of type 'datetime.date'");
    }

    @Test
    public void testTypeTime() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION get_time(x time(6))\nRETURNS time(6)\nLANGUAGE PYTHON\nWITH (handler = 'get_time')\nAS $$\nfrom datetime import time\ndef get_time(x):\n    assert str(x) == '03:23:56.123456'\n    r = time(11, 42, 59, 246912)\n    assert str(r) == '11:42:59.246912'\n    return r\n$$\nSELECT get_time(time '3:23:56.123456')\n"))).matches("VALUES time '11:42:59.246912'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION get_time(x time(6))\nRETURNS time(3)\nLANGUAGE PYTHON\nWITH (handler = 'get_time')\nAS $$\ndef get_time(x):\n    assert str(x) == '23:42:59.999666'\n    return x\n$$\nSELECT get_time(time '23:42:59.999666')\n"))).matches("VALUES time '23:43:00.000'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION get_time(x time(9))\nRETURNS time(6)\nLANGUAGE PYTHON\nWITH (handler = 'get_time')\nAS $$\ndef get_time(x):\n    assert str(x) == '23:42:59.999556'\n    return x\n$$\nSELECT get_time(time '23:42:59.999555888')\n"))).matches("VALUES time '23:42:59.999556'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION bad_time_return()\nRETURNS time\nLANGUAGE PYTHON\nWITH (handler = 'invalid')\nAS $$\ndef invalid():\n    return 123\n$$\nSELECT bad_time_return()\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR}).hasMessage("Failed to convert Python result type 'int' to Trino type TIME: TypeError: expected an instance of type 'datetime.time'");
    }

    @Test
    public void testTypeTimeWithTimeZone() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION get_time(x time(6) with time zone)\nRETURNS time(6) with time zone\nLANGUAGE PYTHON\nWITH (handler = 'get_time')\nAS $$\nfrom datetime import time, timezone, timedelta\ndef get_time(x):\n    assert str(x) == '03:23:56.123456-08:15'\n    r = time(11, 42, 59, 246912, timezone(timedelta(minutes=155)))\n    assert str(r) == '11:42:59.246912+02:35'\n    return r\n$$\nSELECT get_time(cast('3:23:56.123456-08:15' AS time(6) with time zone))\n"))).matches("VALUES cast('11:42:59.246912+02:35' AS time(6) with time zone)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION get_time(x time(6) with time zone)\nRETURNS time(3) with time zone\nLANGUAGE PYTHON\nWITH (handler = 'get_time')\nAS $$\ndef get_time(x):\n    assert str(x) == '23:42:59.999666+11:45'\n    return x\n$$\nSELECT get_time(cast('23:42:59.999666+11:45' AS time(6) with time zone))\n"))).matches("VALUES cast('23:43:00.000+11:45' AS time(3) with time zone)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION get_time(x time(9) with time zone)\nRETURNS time(6) with time zone\nLANGUAGE PYTHON\nWITH (handler = 'get_time')\nAS $$\ndef get_time(x):\n    assert str(x) == '23:42:59.999556-08:00'\n    return x\n$$\nSELECT get_time(cast('23:42:59.999555888-08:00' AS time(9) with time zone))\n"))).matches("VALUES cast('23:42:59.999556-08:00' AS time(6) with time zone)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION get_time(x time(12) with time zone)\nRETURNS time(12) with time zone\nLANGUAGE PYTHON\nWITH (handler = 'get_time')\nAS $$\ndef get_time(x):\n    assert str(x) == '23:42:59.999556-10:00'\n    return x\n$$\nSELECT get_time(cast('23:42:59.999555888555-10:00' AS time(12) with time zone))\n"))).matches("VALUES cast('23:42:59.999556-10:00' AS time(12) with time zone)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION bad_time_return()\nRETURNS time with time zone\nLANGUAGE PYTHON\nWITH (handler = 'invalid')\nAS $$\ndef invalid():\n    return 123\n$$\nSELECT bad_time_return()\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR}).hasMessage("Failed to convert Python result type 'int' to Trino type TIME WITH TIME ZONE: TypeError: expected an instance of type 'datetime.time'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION bad_time_no_tz()\nRETURNS time with time zone\nLANGUAGE PYTHON\nWITH (handler = 'invalid')\nAS $$\nfrom datetime import time\ndef invalid():\n    return time(1, 22, 33)\n$$\nSELECT bad_time_no_tz()\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR}).hasMessage("Failed to convert Python result type 'datetime.time' to Trino type TIME WITH TIME ZONE: ValueError: time instance does not have tzinfo");
    }

    @Test
    public void testTypeTimestamp() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION add_timestamp(x timestamp(6))\nRETURNS timestamp(6)\nLANGUAGE PYTHON\nWITH (handler = 'add_timestamp')\nAS $$\nfrom datetime import timedelta\ndef add_timestamp(x):\n    assert str(x) == '2024-05-06 11:42:54.123456'\n    r = x + timedelta(weeks=5, days=2, hours=3, minutes=4, seconds=5, microseconds=123456)\n    assert str(r) == '2024-06-12 14:46:59.246912'\n    return r\n$$\nSELECT add_timestamp(timestamp '2024-05-06 11:42:54.123456')\n"))).matches("VALUES timestamp '2024-06-12 14:46:59.246912'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION get_timestamp(x timestamp(9))\nRETURNS timestamp(6)\nLANGUAGE PYTHON\nWITH (handler = 'get_timestamp')\nAS $$\ndef get_timestamp(x):\n    assert str(x) == '2024-11-12 23:42:59.123456'\n    return x\n$$\nSELECT get_timestamp(timestamp '2024-11-12 23:42:59.123456123')\n"))).matches("VALUES timestamp '2024-11-12 23:42:59.123456'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION to_short_timestamp(x timestamp(12))\nRETURNS timestamp(3)\nLANGUAGE PYTHON\nWITH (handler = 'get_timestamp')\nAS $$\ndef get_timestamp(x):\n    assert str(x) == '2024-11-12 23:42:59.999667'\n    return x\n$$\nSELECT to_short_timestamp(timestamp '2024-11-12 23:42:59.999666555444')\n"))).matches("VALUES timestamp '2024-11-12 23:43:00.000'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION to_long_timestamp(x timestamp(6))\nRETURNS timestamp(9)\nLANGUAGE PYTHON\nWITH (handler = 'get_timestamp')\nAS $$\ndef get_timestamp(x):\n    assert str(x) == '2024-11-12 23:42:59.999666'\n    return x\n$$\nSELECT to_long_timestamp(timestamp '2024-11-12 23:42:59.999666')\n"))).matches("VALUES timestamp '2024-11-12 23:42:59.999666000'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION to_long_timestamp(x timestamp(6))\nRETURNS timestamp(12)\nLANGUAGE PYTHON\nWITH (handler = 'get_timestamp')\nAS $$\ndef get_timestamp(x):\n    assert str(x) == '2024-11-12 23:42:59.999666'\n    return x\n$$\nSELECT to_long_timestamp(timestamp '2024-11-12 23:42:59.999666')\n"))).matches("VALUES timestamp '2024-11-12 23:42:59.999666000000'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION bad_timestamp_return()\nRETURNS timestamp\nLANGUAGE PYTHON\nWITH (handler = 'invalid')\nAS $$\ndef invalid():\n    return 123\n$$\nSELECT bad_timestamp_return()\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR}).hasMessage("Failed to convert Python result type 'int' to Trino type TIMESTAMP: TypeError: expected an instance of type 'datetime.datetime'");
    }

    @Test
    public void testTypeTimestampWithTimeZone() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION get_timestamp(x timestamp(6) with time zone)\nRETURNS timestamp(6) with time zone\nLANGUAGE PYTHON\nWITH (handler = 'get_time')\nAS $$\nfrom datetime import datetime, timezone, timedelta\ndef get_time(x):\n    assert str(x) == '2024-05-06 03:23:56.123456-08:15'\n    r = datetime(2024, 8, 17, 11, 42, 59, 246912, timezone(timedelta(minutes=155)))\n    assert str(r) == '2024-08-17 11:42:59.246912+02:35'\n    return r\n$$\nSELECT get_timestamp(cast('2024-05-06 3:23:56.123456-08:15' AS timestamp(6) with time zone))\n"))).matches("VALUES cast('2024-08-17 11:42:59.246912+02:35' AS timestamp(6) with time zone)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION to_short_timestamp(x timestamp(9) with time zone)\nRETURNS timestamp(2) with time zone\nLANGUAGE PYTHON\nWITH (handler = 'get_timestamp')\nAS $$\ndef get_timestamp(x):\n    assert str(x) == '2024-11-12 23:42:59.888889+11:45'\n    return x\n$$\nSELECT to_short_timestamp(cast('2024-11-12 23:42:59.888888888+11:45' AS timestamp(9) with time zone))\n"))).matches("VALUES cast('2024-11-12 23:42:59.89+11:45' AS timestamp(2) with time zone)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION to_long_timestamp(x timestamp(3) with time zone)\nRETURNS timestamp(6) with time zone\nLANGUAGE PYTHON\nWITH (handler = 'get_timestamp')\nAS $$\ndef get_timestamp(x):\n    assert str(x) == '2024-11-12 23:42:59.888000-08:00'\n    return x\n$$\nSELECT to_long_timestamp(cast('2024-11-12 23:42:59.888-08:00' AS timestamp(3) with time zone))\n"))).matches("VALUES cast('2024-11-12 23:42:59.888000-08:00' AS timestamp(6) with time zone)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION to_long_timestamp(x timestamp(6) with time zone)\nRETURNS timestamp(12) with time zone\nLANGUAGE PYTHON\nWITH (handler = 'get_timestamp')\nAS $$\ndef get_timestamp(x):\n    assert str(x) == '2024-11-12 23:42:59.999666-10:00'\n    return x\n$$\nSELECT to_long_timestamp(cast('2024-11-12 23:42:59.999666-10:00' AS timestamp(6) with time zone))\n"))).matches("VALUES cast('2024-11-12 23:42:59.999666000000-10:00' AS timestamp(12) with time zone)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION from_non_fixed(x timestamp(6) with time zone)\nRETURNS timestamp(6) with time zone\nLANGUAGE PYTHON\nWITH (handler = 'get_timestamp')\nAS $$\ndef get_timestamp(x):\n    assert str(x) == '2024-07-04 21:35:20.123456-07:00'\n    return x\n$$\nSELECT from_non_fixed(cast('2024-07-04 21:35:20.123456 America/Los_Angeles' AS timestamp(6) with time zone))\n"))).matches("VALUES cast('2024-07-04 21:35:20.123456-07:00' AS timestamp(6) with time zone)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION bad_timestamp_return()\nRETURNS timestamp with time zone\nLANGUAGE PYTHON\nWITH (handler = 'invalid')\nAS $$\ndef invalid():\n    return 123\n$$\nSELECT bad_timestamp_return()\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR}).hasMessage("Failed to convert Python result type 'int' to Trino type TIMESTAMP WITH TIME ZONE: TypeError: expected an instance of type 'datetime.datetime'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION bad_timestamp_no_tz()\nRETURNS timestamp with time zone\nLANGUAGE PYTHON\nWITH (handler = 'invalid')\nAS $$\nfrom datetime import datetime\ndef invalid():\n    return datetime(2, 3, 4, 5, 6, 7)\n$$\nSELECT bad_timestamp_no_tz()\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR}).hasMessage("Failed to convert Python result type 'datetime.datetime' to Trino type TIMESTAMP WITH TIME ZONE: ValueError: datetime instance does not have tzinfo");
    }

    @Test
    public void testTypeIntervalYearToMonth() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION add_months(x interval year to month)\nRETURNS interval year to month\nLANGUAGE PYTHON\nWITH (handler = 'add_months')\nAS $$\ndef add_months(x):\n    return x + 42;\n$$\nSELECT add_months(interval '5-9' year to month)\n"))).matches("VALUES interval '9-3' year to month");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION bad_interval_return()\nRETURNS interval year to month\nLANGUAGE PYTHON\nWITH (handler = 'invalid')\nAS $$\ndef invalid():\n    return '13-2'\n$$\nSELECT bad_interval_return()\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR}).hasMessage("Failed to convert Python result type 'str' to Trino type INTERVAL YEAR TO MONTH: TypeError: 'str' object cannot be interpreted as an integer");
    }

    @Test
    public void testTypeIntervalDayToSecond() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION get_interval(x interval day to second)\nRETURNS interval day to second\nLANGUAGE PYTHON\nWITH (handler = 'get_interval')\nAS $$\nfrom datetime import timedelta\ndef get_interval(x):\n    assert str(x) == '5 days, 9:23:56.123000'\n    return timedelta(days=3, hours=18, minutes=42, seconds=33, microseconds=888888)\n$$\nSELECT get_interval(interval '5 9:23:56.123' day to second)\n"))).matches("VALUES (interval '3 18:42:33.889' day to second)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION bad_interval_return()\nRETURNS interval day to second\nLANGUAGE PYTHON\nWITH (handler = 'invalid')\nAS $$\ndef invalid():\n    return 123\n$$\nSELECT bad_interval_return()\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR}).hasMessage("Failed to convert Python result type 'int' to Trino type INTERVAL DAY TO SECOND: TypeError: expected an instance of type 'datetime.timedelta'");
    }

    @Test
    public void testTypeJson() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION update_json(x json)\nRETURNS json\nLANGUAGE PYTHON\nWITH (handler = 'update_json')\nAS $$\nimport json\ndef update_json(x):\n    assert x == '{\"bar\":456,\"foo\":123}'\n    v = json.loads(x)\n    v['abc'] = 'xyz'\n    return json.dumps(v)\n$$\nSELECT update_json(json '{\"foo\": 123, \"bar\": 456}')\n"))).matches("VALUES json '{\"abc\": \"xyz\", \"bar\": 456, \"foo\": 123}'\n");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION bad_json_return()\nRETURNS json\nLANGUAGE PYTHON\nWITH (handler = 'invalid')\nAS $$\ndef invalid():\n    return 123\n$$\nSELECT bad_json_return()\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR}).hasMessage("Failed to convert Python result type 'int' to Trino type JSON: TypeError: expected an instance of type 'str'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION bad_json_value()\nRETURNS json\nLANGUAGE PYTHON\nWITH (handler = 'invalid')\nAS $$\ndef invalid():\n    return 'xxx'\n$$\nSELECT bad_json_value()\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR}).hasMessage("Python function returned invalid JSON value");
    }

    @Test
    public void testTypeUuid() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION uuid_to_str(x uuid)\nRETURNS varchar\nLANGUAGE PYTHON\nWITH (handler = 'convert')\nAS $$\ndef convert(x):\n    return str(x)\n$$\nSELECT uuid_to_str(uuid '6b5f5b65-67e4-43b0-8ee3-586cd49f58a1'),\n       uuid_to_str(uuid 'dfa7eaf8-6a26-5749-8d36-336025df74e8')\n"))).skippingTypesCheck().matches("VALUES ('6b5f5b65-67e4-43b0-8ee3-586cd49f58a1',\n        'dfa7eaf8-6a26-5749-8d36-336025df74e8')\n");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION str_to_uuid(x varchar)\nRETURNS uuid\nLANGUAGE PYTHON\nWITH (handler = 'convert')\nAS $$\nfrom uuid import UUID\ndef convert(x):\n    return UUID(x)\n$$\nSELECT str_to_uuid('6b5f5b65-67e4-43b0-8ee3-586cd49f58a1'),\n       str_to_uuid('dfa7eaf8-6a26-5749-8d36-336025df74e8')\n"))).matches("VALUES (uuid '6b5f5b65-67e4-43b0-8ee3-586cd49f58a1',\n        uuid 'dfa7eaf8-6a26-5749-8d36-336025df74e8')\n");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION bad_uuid_return()\nRETURNS uuid\nLANGUAGE PYTHON\nWITH (handler = 'invalid')\nAS $$\ndef invalid():\n    return 'hello'\n$$\nSELECT bad_uuid_return()\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR}).hasMessage("Failed to convert Python result type 'str' to Trino type UUID: TypeError: expected an instance of type 'UUID'");
    }

    @Test
    public void testTypeIpaddress() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION ip_to_str(x ipaddress)\nRETURNS varchar\nLANGUAGE PYTHON\nWITH (handler = 'convert')\nAS $$\ndef convert(x):\n    return type(x).__name__ + ':' + str(x)\n$$\nSELECT ip_to_str(ipaddress '192.168.1.5'),\n       ip_to_str(ipaddress '12.34.56.78'),\n       ip_to_str(ipaddress '2001:0db8:0000:0000:0000:ff00:0042:8329'),\n       ip_to_str(ipaddress '2001:db8:0:0:1::1'),\n       ip_to_str(ipaddress '::ffff:1.2.3.4')\n"))).skippingTypesCheck().matches("VALUES ('IPv4Address:192.168.1.5',\n        'IPv4Address:12.34.56.78',\n        'IPv6Address:2001:db8::ff00:42:8329',\n        'IPv6Address:2001:db8::1:0:0:1',\n        'IPv4Address:1.2.3.4')\n");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION str_to_ip(x varchar)\nRETURNS ipaddress\nLANGUAGE PYTHON\nWITH (handler = 'convert')\nAS $$\nfrom ipaddress import ip_address\ndef convert(x):\n    return ip_address(x)\n$$\nSELECT str_to_ip('192.168.1.5'),\n       str_to_ip('12.34.56.78'),\n       str_to_ip('2001:0db8:0000:0000:0000:ff00:0042:8329'),\n       str_to_ip('2001:db8:0:0:1::1'),\n       str_to_ip('::ffff:1.2.3.4')\n"))).matches("VALUES (ipaddress '192.168.1.5',\n        ipaddress '12.34.56.78',\n        ipaddress '2001:db8::ff00:42:8329',\n        ipaddress '2001:db8::1:0:0:1',\n        ipaddress '1.2.3.4')\n");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION bad_ip_return()\nRETURNS ipaddress\nLANGUAGE PYTHON\nWITH (handler = 'invalid')\nAS $$\ndef invalid():\n    return 'hello'\n$$\nSELECT bad_ip_return()\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR}).hasMessage("Failed to convert Python result type 'str' to Trino type IPADDRESS: TypeError: expected an instance of type 'ipaddress.IPv4Address' or 'ipaddress.IPv6Address'");
    }

    @Test
    public void testTypeRow() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION get_row(x row(a integer, b varchar))\nRETURNS row(a integer, b varchar)\nLANGUAGE PYTHON\nWITH (handler = 'get_row')\nAS $$\ndef get_row(x):\n    assert x == (123, 'hello')\n    return x\n$$\nSELECT get_row(row(123, 'hello'))\n"))).skippingTypesCheck().matches("SELECT row(123, 'hello')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION bad_row_return()\nRETURNS row(a integer, b varchar)\nLANGUAGE PYTHON\nWITH (handler = 'invalid')\nAS $$\ndef invalid():\n    return 123\n$$\nSELECT bad_row_return()\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR}).hasMessage("Failed to convert Python result type 'int' to Trino type ROW: TypeError: expected an instance of type 'tuple'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION bad_row_count()\nRETURNS row(a integer, b varchar)\nLANGUAGE PYTHON\nWITH (handler = 'invalid')\nAS $$\ndef invalid():\n    return (123, 'hello', 789)\n$$\nSELECT bad_row_count()\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR}).hasMessage("Failed to convert Python result type 'tuple' to Trino type ROW: ValueError: tuple has 3 fields, expected 2 fields for row");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION bad_row_value()\nRETURNS row(a integer, b varchar)\nLANGUAGE PYTHON\nWITH (handler = 'invalid')\nAS $$\ndef invalid():\n    return ('hello', 123)\n$$\nSELECT bad_row_value()\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR}).hasMessage("Failed to convert Python result type 'str' to Trino type INTEGER: TypeError: 'str' object cannot be interpreted as an integer");
    }

    @Test
    public void testTypeArray() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION get_array(x array(integer))\nRETURNS array(integer)\nLANGUAGE PYTHON\nWITH (handler = 'get_array')\nAS $$\ndef get_array(x):\n    assert x == [1, 2, 3]\n    return x\n$$\nSELECT get_array(array[1, 2, 3])\n"))).matches("VALUES array[1, 2, 3]");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION bad_array_return()\nRETURNS array(integer)\nLANGUAGE PYTHON\nWITH (handler = 'invalid')\nAS $$\ndef invalid():\n    return 123\n$$\nSELECT bad_array_return()\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR}).hasMessage("Failed to convert Python result type 'int' to Trino type ARRAY: TypeError: expected an instance of type 'list'");
    }

    @Test
    public void testTypeMap() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION get_map(x map(integer, varchar))\nRETURNS map(integer, varchar)\nLANGUAGE PYTHON\nWITH (handler = 'get_map')\nAS $$\ndef get_map(x):\n    assert x == {1: 'a', 2: 'b', 3: 'c'}\n    return x\n$$\nSELECT get_map(map_from_entries(ARRAY[(1, 'a'), (2, 'b'), (3, 'c')]))\n"))).skippingTypesCheck().matches("VALUES map_from_entries(ARRAY[(1, 'a'), (2, 'b'), (3, 'c')])");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION bad_map_return()\nRETURNS map(integer, varchar)\nLANGUAGE PYTHON\nWITH (handler = 'invalid')\nAS $$\ndef invalid():\n    return 123\n$$\nSELECT bad_map_return()\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR}).hasMessage("Failed to convert Python result type 'int' to Trino type MAP: TypeError: expected an instance of type 'dict'");
    }

    @Test
    public void testNestedTypes() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION get_nested(x row(array(varchar), map(varchar, integer), row(integer, integer)))\nRETURNS row(array(varchar), map(varchar, integer), row(integer, integer))\nLANGUAGE PYTHON\nWITH (handler = 'get_nested')\nAS $$\ndef get_nested(x):\n    assert x == (['a', 'b'], {'c': 1, 'd': 2}, (3, 4))\n    return x\n$$\nSELECT get_nested(row(array['a', 'b'], map_from_entries(ARRAY[('c', 1), ('d', 2)]), row(3, 4)))\n"))).skippingTypesCheck().matches("SELECT row(array['a', 'b'], map_from_entries(ARRAY[('c', 1), ('d', 2)]), row(3, 4))");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query("WITH FUNCTION get_nested(x row(\n    boolean,\n    boolean,\n    bigint,\n    integer,\n    smallint,\n    tinyint,\n    double,\n    real,\n    decimal(18, 5),\n    decimal(25, 5),\n    varchar,\n    varbinary,\n    date,\n    time(9),\n    time(9) with time zone,\n    time(12) with time zone,\n    timestamp(3),\n    timestamp(9),\n    timestamp(3) with time zone,\n    timestamp(9) with time zone,\n    interval year to month,\n    interval day to second,\n    json,\n    uuid,\n    ipaddress))\nRETURNS row(\n    boolean,\n    boolean,\n    bigint,\n    integer,\n    smallint,\n    tinyint,\n    double,\n    real,\n    decimal(18, 5),\n    decimal(25, 5),\n    varchar,\n    varbinary,\n    date,\n    time(5),\n    time(5) with time zone,\n    time(6) with time zone,\n    timestamp(3),\n    timestamp(5),\n    timestamp(3) with time zone,\n    timestamp(5) with time zone,\n    interval year to month,\n    interval day to second,\n    json,\n    uuid,\n    ipaddress)\nLANGUAGE PYTHON\nWITH (handler = 'get_nested')\nAS $$\nfrom decimal import Decimal\nfrom datetime import date, time, datetime, timedelta, timezone\nfrom uuid import UUID\nfrom ipaddress import ip_address\ndef get_nested(x):\n    assert x == (\n        None,\n        True,\n        1234567890123456789,\n        1234567890,\n        12345,\n        123,\n        8381.0205,\n        123.5,\n        Decimal('123.45600'),\n        Decimal('12345678901234567890.12340'),\n        'hello',\n        b'world',\n        date(2024, 6, 27),\n        time(3, 23, 56, 123457),\n        time(3, 23, 56, 123457, timezone(timedelta(minutes=155))),\n        time(3, 23, 56, 123457, timezone(timedelta(minutes=155))),\n        datetime(2024, 5, 6, 11, 42, 54, 123000),\n        datetime(2024, 5, 6, 11, 42, 54, 123457),\n        datetime(2024, 5, 6, 11, 42, 54, 123000, timezone(timedelta(hours=-7))),\n        datetime(2024, 5, 6, 11, 42, 54, 123457, timezone(timedelta(hours=-7))),\n        67,\n        timedelta(days=5, hours=9, minutes=23, seconds=56, milliseconds=123),\n        '{\"bar\":456,\"foo\":123}',\n        UUID('6b5f5b65-67e4-43b0-8ee3-586cd49f58a1'),\n        ip_address('12.34.56.78'))\n    return x\n$$\nSELECT get_nested(row(\n    cast(null AS boolean),\n    true,\n    1234567890123456789,\n    1234567890,\n    smallint '12345',\n    tinyint '123',\n    double '8381.0205',\n    real '123.5',\n    cast(123.456 AS decimal(15, 5)),\n    cast(12345678901234567890.1234 AS decimal(25, 5)),\n    varchar 'hello',\n    varbinary 'world',\n    date '2024-06-27',\n    cast('3:23:56.123456888' AS time(9)),\n    cast('3:23:56.123456888+02:35' AS time(9) with time zone),\n    cast('3:23:56.123456888999+02:35' AS time(12) with time zone),\n    cast('2024-05-06 11:42:54.123' as timestamp(3)),\n    cast('2024-05-06 11:42:54.123456888' as timestamp(9)),\n    cast('2024-05-06 11:42:54.123 America/Los_Angeles' AS timestamp(3) with time zone),\n    cast('2024-05-06 11:42:54.123456888 America/Los_Angeles' AS timestamp(9) with time zone),\n    interval '5-7' year to month,\n    interval '5 9:23:56.123888' day to second,\n    json '{\"foo\": 123, \"bar\": 456}',\n    uuid '6b5f5b65-67e4-43b0-8ee3-586cd49f58a1',\n    ipaddress '12.34.56.78'))\n"))).matches("SELECT row(\n    cast(null AS boolean),\n    true,\n    1234567890123456789,\n    1234567890,\n    smallint '12345',\n    tinyint '123',\n    double '8381.0205',\n    real '123.5',\n    cast(123.456 AS decimal(18, 5)),\n    cast(12345678901234567890.1234 AS decimal(25, 5)),\n    varchar 'hello',\n    varbinary 'world',\n    date '2024-06-27',\n    time '03:23:56.12346',\n    time '03:23:56.12346+02:35',\n    time '03:23:56.123457+02:35',\n    timestamp '2024-05-06 11:42:54.123',\n    timestamp '2024-05-06 11:42:54.12346',\n    timestamp '2024-05-06 11:42:54.123-07:00',\n    timestamp '2024-05-06 11:42:54.12346-07:00',\n    interval '5-7' year to month,\n    interval '5 09:23:56.123' day to second,\n    json '{\"bar\": 456, \"foo\": 123}',\n    uuid '6b5f5b65-67e4-43b0-8ee3-586cd49f58a1',\n    ipaddress '12.34.56.78')\n");
    }
}

